/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags;

import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;
import net.noscape.project.supremetags.checkers.Metrics;
import net.noscape.project.supremetags.checkers.UpdateChecker;
import net.noscape.project.supremetags.commands.Tags;
import net.noscape.project.supremetags.handlers.hooks.PAPI;
import net.noscape.project.supremetags.handlers.menu.MenuListener;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.listeners.PlayerEvents;
import net.noscape.project.supremetags.managers.CategoryManager;
import net.noscape.project.supremetags.managers.TagManager;
import net.noscape.project.supremetags.storage.H2Database;
import net.noscape.project.supremetags.storage.H2UserData;
import net.noscape.project.supremetags.storage.MySQL;
import net.noscape.project.supremetags.storage.MySQLUserData;
import net.noscape.project.supremetags.storage.UserData;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SupremeTags
extends JavaPlugin {
    private static SupremeTags instance;
    private final TagManager tagManager = new TagManager();
    private final CategoryManager categoryManager = new CategoryManager();
    private static MySQL mysql;
    private static H2Database h2;
    private final H2UserData h2user = new H2UserData();
    private static String connectionURL;
    private static String layout;
    private final MySQLUserData user = new MySQLUserData();
    private static final HashMap<Player, MenuUtil> menuUtilMap;
    private boolean legacy_format;
    private final String host = this.getConfig().getString("data.address");
    private final int port = this.getConfig().getInt("data.port");
    private final String database = this.getConfig().getString("data.database");
    private final String username = this.getConfig().getString("data.username");
    private final String password = this.getConfig().getString("data.password");
    private final String options = this.getConfig().getString("data.options");

    public void onEnable() {
        instance = this;
        Logger log = this.getLogger();
        if (this.getServer().getPluginManager().getPlugin("NBTAPI") == null) {
            log.warning("------------------------------");
            log.warning("[NBTAPI] NBTAPI is required for SupremeTags-" + this.getDescription().getVersion() + " to work!");
            log.warning("------------------------------");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            log.fine("------------------------------");
            log.fine("[NBTAPI] NBTAPI has been found for SupremeTags-" + this.getDescription().getVersion() + "!");
            log.fine("------------------------------");
        }
        this.saveDefaultConfig();
        this.callMetrics();
        if (this.isH2().booleanValue()) {
            connectionURL = "jdbc:h2:" + this.getDataFolder().getAbsolutePath() + "/database";
            h2 = new H2Database(connectionURL);
        }
        if (this.isMySQL().booleanValue()) {
            mysql = new MySQL(this.host, this.port, this.database, this.username, this.password, this.options);
        }
        if (this.getConfig().getBoolean("settings.update-check")) {
            UpdateChecker updater = new UpdateChecker((Plugin)this);
            updater.fetch();
            if (updater.hasUpdateAvailable()) {
                log.warning("------------------------------");
                log.warning("SupremeTags-Checker");
                log.warning(" ");
                log.warning("An update for SupremeTags has been found!");
                log.warning("SupremeTags-" + updater.getSpigotVersion());
                log.warning("You are running " + this.getDescription().getVersion());
                log.warning(" ");
                log.warning("Download at https://www.spigotmc.org/resources/%E2%9C%85-supremetags-%E2%9C%85-1-8-1-19-placeholderapi-support-unlimited-tags-%E2%9C%85.103140/");
                log.warning("------------------------------");
            } else {
                log.fine("------------------------------");
                log.fine("Running latest version of SupremeTags-" + this.getDescription().getVersion());
                log.fine("------------------------------");
            }
        }
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PAPI(this).register();
            log.fine("------------------------------");
            log.fine("PlaceholderAPI found SupremeTags! Automatically downloaded cloud.");
            log.fine("------------------------------");
        }
        Objects.requireNonNull(this.getCommand("tags")).setExecutor((CommandExecutor)new Tags());
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(), (Plugin)this);
        if (Objects.requireNonNull(this.getConfig().getString("settings.layout")).equalsIgnoreCase("layout1")) {
            layout = "layout1";
        } else if (Objects.requireNonNull(this.getConfig().getString("settings.layout")).equalsIgnoreCase("layout2")) {
            layout = "layout2";
        }
        this.legacy_format = this.getConfig().getBoolean("settings.legacy-hex-format");
        this.merge(log);
        this.tagManager.loadTags();
        this.categoryManager.loadCategories();
        this.categoryManager.loadCategoriesTags();
        this.tagManager.getDataItem().clear();
    }

    public void onDisable() {
        this.tagManager.unloadTags();
    }

    public static SupremeTags getInstance() {
        return instance;
    }

    public TagManager getTagManager() {
        return this.tagManager;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public static MenuUtil getMenuUtil(Player player) {
        if (menuUtilMap.containsKey(player)) {
            return menuUtilMap.get(player);
        }
        MenuUtil menuUtil = new MenuUtil(player, UserData.getActive(player.getUniqueId()));
        menuUtilMap.put(player, menuUtil);
        return menuUtil;
    }

    public static MenuUtil getMenuUtil(Player player, String category) {
        if (menuUtilMap.containsKey(player)) {
            return menuUtilMap.get(player);
        }
        MenuUtil menuUtil = new MenuUtil(player, UserData.getActive(player.getUniqueId()), category);
        menuUtilMap.put(player, menuUtil);
        return menuUtil;
    }

    public static String getConnectionURL() {
        return connectionURL;
    }

    public static String getLayout() {
        return layout;
    }

    public static void setLayout(String layout) {
        SupremeTags.layout = layout;
    }

    public H2UserData getUserData() {
        return this.h2user;
    }

    public static H2Database getDatabase() {
        return h2;
    }

    public MySQLUserData getUser() {
        return SupremeTags.instance.user;
    }

    public static MySQL getMysql() {
        return mysql;
    }

    public void reloadConfig() {
        super.reloadConfig();
    }

    public boolean isLegacyFormat() {
        return this.legacy_format;
    }

    public void merge(Logger log) {
        if (this.getConfig().getBoolean("settings.auto-merge")) {
            File configFile = new File(Bukkit.getServer().getWorldContainer().getAbsolutePath() + "/plugins/DeluxeTags/config.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (configFile.exists()) {
                if (config.getConfigurationSection("deluxetags") != null) {
                    for (String identifier : Objects.requireNonNull(config.getConfigurationSection("deluxetags")).getKeys(false)) {
                        if (!SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                            String tag = config.getString("deluxetags." + identifier + ".tag");
                            String description = config.getString("deluxetags." + identifier + ".description");
                            String permission = config.getString("deluxetags." + identifier + ".permission");
                            SupremeTags.getInstance().getTagManager().createTag(identifier, tag, description, permission);
                        }
                        log.fine("Merger: &7Added all new tags from DeluxeTags were added, any existing tags with the same name won't be added.");
                    }
                } else {
                    log.warning("Error: DeluxeTags tag config area is empty.");
                }
            } else {
                log.warning("Error: DeluxeTags can not be found.");
            }
        }
    }

    public Boolean isH2() {
        return Objects.requireNonNull(this.getConfig().getString("data.type")).equalsIgnoreCase("H2");
    }

    public Boolean isMySQL() {
        return Objects.requireNonNull(this.getConfig().getString("data.type")).equalsIgnoreCase("MYSQL");
    }

    private void callMetrics() {
        int pluginId = 103140;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("used_language", () -> this.getConfig().getString("language", "en")));
        metrics.addCustomChart(new Metrics.DrilldownPie("java_version", () -> {
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            if (javaVersion.startsWith("1.7")) {
                map.put("Java 1.7", entry);
            } else if (javaVersion.startsWith("1.8")) {
                map.put("Java 1.8", entry);
            } else if (javaVersion.startsWith("1.9")) {
                map.put("Java 1.9", entry);
            } else {
                map.put("Other", entry);
            }
            return map;
        }));
    }

    static {
        menuUtilMap = new HashMap();
    }
}

