/*
 * Decompiled with CFR 0.152.
 */
package rd.dru.nms;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import rd.dru.SuperHarvest;
import rd.dru.nms.NMSHandler;

public class V1_17Handler
implements NMSHandler {
    @Override
    public boolean breakBlock(Player p, Block b) {
        return p.breakBlock(b);
    }

    @Override
    public ItemStack getItemInHand(Player p) {
        return p.getInventory().getItemInMainHand();
    }

    @Override
    public void crackBlock(Block b, Material type) {
        b.getWorld().spawnParticle(Particle.BLOCK_CRACK, b.getLocation().add(0.5, 0.5, 0.5), 25, 1.0, 0.1, 0.1, 0.1, (Object)type.createBlockData());
    }

    @Override
    public void crackCrop(Block b, Material type) {
        if (type.equals((Object)Material.NETHER_WART)) {
            this.crackBlock(b, Material.NETHER_WART);
        } else {
            this.crackBlock(b, Material.LEGACY_CROPS);
        }
    }

    @Override
    public void playSound(Block b, NMSHandler.NSound sound) {
        b.getWorld().playSound(b.getLocation(), b.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
    }

    @Override
    public void playSound(Block b, Material sound) {
        b.getWorld().playSound(b.getLocation(), sound.createBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
    }

    @Override
    public boolean isCrop(Block b) {
        return b.getBlockData() instanceof Ageable;
    }

    @Override
    public boolean isFarmLnad(Block b) {
        return b.getType().equals((Object)Material.FARMLAND) || b.getType().equals((Object)Material.SOUL_SAND);
    }

    @Override
    public boolean canCropHarvest(Block b) {
        if (!SuperHarvest.nms.isCrop(b)) {
            return false;
        }
        Ageable age = (Ageable)b.getBlockData();
        return age.getAge() == age.getMaximumAge();
    }

    @Override
    public void actionBarMes(Player p, String mes) {
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(mes));
    }

    @Override
    public void titleBarMes(Player p, String mes) {
        p.sendTitle(" ", mes, 0, 20, 10);
    }
}

