/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.particles;

import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    @Nonnull
    public Particle particle;
    @Nullable
    public Location location;
    @Nullable
    public Callable<Location> locationCaller;
    public int count;
    public double offsetx;
    public double offsety;
    public double offsetz;
    public double extra;
    @Nullable
    public Vector rotation;
    public boolean force;
    @Nullable
    private Object data;

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> locationCaller, @Nullable Location location, int count, double offsetx, double offsety, double offsetz, double extra, boolean force) {
        this.particle = particle;
        this.location = location;
        this.locationCaller = locationCaller;
        this.count = count;
        this.offsetx = offsetx;
        this.offsety = offsety;
        this.offsetz = offsetz;
        this.extra = extra;
        this.force = force;
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Callable<Location> locationCaller, @Nullable Location location, int count, double offsetx, double offsety, double offsetz, double extra) {
        this(particle, locationCaller, location, count, offsetx, offsety, offsetz, extra, false);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count, double offsetx, double offsety, double offsetz) {
        this(particle, null, location, count, offsetx, offsety, offsetz, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location, int count) {
        this(particle, location, count, 0.0, 0.0, 0.0);
    }

    public ParticleDisplay(@Nonnull Particle particle, @Nullable Location location) {
        this(particle, location, 0);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int r, int g, int b, float size) {
        ParticleDisplay dust = new ParticleDisplay(Particle.REDSTONE, null, location, 1, 0.0, 0.0, 0.0, 0.0);
        dust.data = new float[]{r, g, b, size};
        return dust;
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float size) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        return new ParticleDisplay(particle, null, location, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay display = ParticleDisplay.simple(location, particle);
        display.spawn();
        return display;
    }

    public static ParticleDisplay fromConfig(@Nullable Location location, @Nonnull ConfigurationSection config) {
        ParticleDisplay display = new ParticleDisplay(DEFAULT_PARTICLE, location);
        return ParticleDisplay.edit(display, config);
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay display, @Nonnull ConfigurationSection config) {
        Material material;
        String[] rotations;
        String rotation;
        String offset;
        Objects.requireNonNull(display, "Cannot edit a null particle display");
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        String particleName = config.getString("particle");
        Particle particle = particleName == null ? null : XParticle.getParticle(particleName);
        int count = config.getInt("count");
        double extra = config.getDouble("extra");
        boolean force = config.getBoolean("force");
        if (particle != null) {
            display.particle = particle;
        }
        if (count != 0) {
            display.withCount(count);
        }
        if (extra != 0.0) {
            display.withExtra(extra);
        }
        if (force) {
            display.withForce(force);
        }
        if ((offset = config.getString("offset")) != null) {
            String[] offsets = StringUtils.split((String)StringUtils.deleteWhitespace((String)offset), (char)',');
            if (offsets.length >= 3) {
                double offsetx = NumberUtils.toDouble((String)offsets[0]);
                double offsety = NumberUtils.toDouble((String)offsets[1]);
                double offsetz = NumberUtils.toDouble((String)offsets[2]);
                display.offset(offsetx, offsety, offsetz);
            } else {
                double masterOffset = NumberUtils.toDouble((String)offsets[0]);
                display.offset(masterOffset, masterOffset, masterOffset);
            }
        }
        if ((rotation = config.getString("rotation")) != null && (rotations = StringUtils.split((String)StringUtils.deleteWhitespace((String)rotation), (char)',')).length >= 3) {
            double x = NumberUtils.toDouble((String)rotations[0]);
            double y = NumberUtils.toDouble((String)rotations[1]);
            double z = NumberUtils.toDouble((String)rotations[2]);
            display.rotation = new Vector(x, y, z);
        }
        String color = config.getString("color");
        String blockdata = config.getString("blockdata");
        String item = config.getString("itemstack");
        String materialdata = config.getString("materialdata");
        if (color != null) {
            String[] colors = StringUtils.split((String)StringUtils.deleteWhitespace((String)color), (char)',');
            if (colors.length >= 3) {
                display.data = new float[]{NumberUtils.toInt((String)colors[0]), NumberUtils.toInt((String)colors[1]), NumberUtils.toInt((String)colors[2]), colors.length > 3 ? NumberUtils.toFloat((String)colors[3]) : 1.0f};
            }
        } else if (blockdata != null) {
            Material material2 = Material.getMaterial((String)blockdata);
            if (material2 != null && material2.isBlock()) {
                display.data = material2.createBlockData();
            }
        } else if (item != null) {
            Material material3 = Material.getMaterial((String)item);
            if (material3 != null && material3.isItem()) {
                display.data = new ItemStack(material3, 1);
            }
        } else if (materialdata != null && (material = Material.getMaterial((String)materialdata)) != null && material.isBlock()) {
            display.data = material.getData();
        }
        return display;
    }

    @Nonnull
    public static Location rotate(@Nonnull Location location, double x, double y, double z, @Nullable Vector rotation) {
        if (rotation == null) {
            return ParticleDisplay.cloneLocation(location).add(x, y, z);
        }
        Vector rotate = new Vector(x, y, z);
        XParticle.rotateAround(rotate, rotation.getX(), rotation.getY(), rotation.getZ());
        return ParticleDisplay.cloneLocation(location).add(rotate);
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offsetx + ", " + this.offsety + ", " + this.offsetz + "}, Extra=" + this.extra + "Force=" + this.force + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public ParticleDisplay withForce(boolean force) {
        this.force = force;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float size) {
        this.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), size};
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = blockData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = materialData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack item) {
        this.data = item;
        return this;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> locationCaller) {
        this.locationCaller = locationCaller;
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.location;
        }
    }

    @Nonnull
    public ParticleDisplay faceEntity(@Nonnull Entity entity) {
        Objects.requireNonNull(entity, "Cannot face null entity");
        Location loc = entity.getLocation();
        this.rotation = new Vector(Math.toRadians(loc.getPitch() + 90.0f), Math.toRadians(-loc.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(x, y, z);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay display = new ParticleDisplay(this.particle, this.locationCaller, this.location == null ? null : ParticleDisplay.cloneLocation(this.location), this.count, this.offsetx, this.offsety, this.offsetz, this.extra, this.force);
        if (this.rotation != null) {
            display.rotation = new Vector(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ());
        }
        display.data = this.data;
        return display;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double x, double y, double z) {
        return this.rotate(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(double x, double y, double z) {
        this.offsetx = x;
        this.offsety = y;
        this.offsetz = z;
        return this;
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector location) {
        Objects.requireNonNull(location, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(location.getX(), location.getY(), location.getZ());
    }

    @Nonnull
    public Location spawn(double x, double y, double z) {
        return this.spawn(ParticleDisplay.rotate(this.getLocation(), x, y, z, this.rotation));
    }

    @Nonnull
    public Location spawn(@Nonnull Location loc) {
        return this.spawn(loc, null);
    }

    @Nonnull
    public Location spawn(@Nonnull Location loc, Player ... players) {
        if (this.data != null && this.data instanceof float[]) {
            float[] datas = (float[])this.data;
            if (ISFLAT && this.particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dust = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)datas[0]), (int)((int)datas[1]), (int)((int)datas[2])), datas[3]);
                if (players == null) {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dust, this.force);
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, (Object)dust);
                    }
                }
            } else if (this.isDirectional()) {
                float[] rgb = new float[]{datas[0] / 255.0f, datas[1] / 255.0f, datas[2] / 255.0f};
                if (players == null) {
                    if (ISFLAT) {
                        loc.getWorld().spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null, this.force);
                    } else {
                        loc.getWorld().spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3], null);
                    }
                } else {
                    for (Player player : players) {
                        player.spawnParticle(this.particle, loc, this.count, (double)rgb[0], (double)rgb[1], (double)rgb[2], (double)datas[3]);
                    }
                }
            } else if (players == null) {
                if (ISFLAT) {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, null, this.force);
                } else {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, null);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra);
                }
            }
        } else {
            Object datas;
            Object object = datas = this.particle.getDataType().isInstance(this.data) ? this.data : null;
            if (players == null) {
                if (ISFLAT) {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, datas, this.force);
                } else {
                    loc.getWorld().spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, datas);
                }
            } else {
                for (Player player : players) {
                    player.spawnParticle(this.particle, loc, this.count, this.offsetx, this.offsety, this.offsetz, this.extra, datas);
                }
            }
        }
        return loc;
    }
}

