/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import com.xinecraft.utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class TPS {
    private static final Class<?> spigotServerClass = ReflectionUtil.getClass("org.bukkit.Server$Spigot");
    private static final Method getSpigotMethod = ReflectionUtil.makeMethod(Bukkit.class, "spigot", new Class[0]);
    private static final Method getTPSMethod = spigotServerClass != null ? ReflectionUtil.makeMethod(spigotServerClass, "getTPS", new Class[0]) : null;
    private static final Class<?> minecraftServerClass = ReflectionUtil.getNmsClass("MinecraftServer");
    private static final Method getServerMethod = minecraftServerClass != null ? ReflectionUtil.makeMethod(minecraftServerClass, "getServer", new Class[0]) : null;
    private static final Field recentTpsField = minecraftServerClass != null ? ReflectionUtil.makeField(minecraftServerClass, "recentTps") : null;

    private TPS() {
    }

    public static double getTPS() {
        return TPS.getAverageTPS(1);
    }

    public static double getAverageTPS(int time) {
        double[] recentTps = TPS.canGetWithPaper() ? TPS.getPaperRecentTps() : TPS.getNMSRecentTps();
        switch (time) {
            case 1: {
                double raw = recentTps[0];
                double tps = Math.min((double)Math.round(raw * 100.0) / 100.0, 20.0);
                return tps;
            }
            case 5: {
                double raw = recentTps[1];
                double tps = Math.min((double)Math.round(raw * 100.0) / 100.0, 20.0);
                return tps;
            }
            case 15: {
                double raw = recentTps[2];
                double tps = Math.min((double)Math.round(raw * 100.0) / 100.0, 20.0);
                return tps;
            }
        }
        throw new IllegalArgumentException("Unsupported tps measure time " + time);
    }

    private static double[] getPaperRecentTps() {
        if (!TPS.canGetWithPaper()) {
            throw new UnsupportedOperationException("Can't get TPS from Paper");
        }
        Object server = ReflectionUtil.callMethod(getServerMethod, null, new Object[0]);
        double[] recent = (double[])ReflectionUtil.getField(recentTpsField, server);
        return recent;
    }

    private static boolean canGetWithPaper() {
        return getSpigotMethod != null && getTPSMethod != null;
    }

    private static double[] getNMSRecentTps() {
        if (getServerMethod == null || recentTpsField == null) {
            throw new UnsupportedOperationException("Can't get TPS from NMS");
        }
        Object server = ReflectionUtil.callMethod(getServerMethod, null, new Object[0]);
        double[] recent = (double[])ReflectionUtil.getField(recentTpsField, server);
        return recent;
    }
}

