/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;

public class SystemUtil {
    public static double getAverageCpuLoad() {
        double averageUsage;
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            if (osBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean nativeOsBean = (OperatingSystemMXBean)osBean;
                averageUsage = nativeOsBean.getSystemCpuLoad();
            } else {
                int availableProcessors = osBean.getAvailableProcessors();
                averageUsage = osBean.getSystemLoadAverage() / (double)availableProcessors;
            }
            if (averageUsage < 0.0) {
                averageUsage = -1.0;
            }
        }
        catch (UnsatisfiedLinkError e) {
            averageUsage = -1.0;
        }
        return averageUsage * 100.0;
    }

    public static long getFreeDiskSpaceInKiloBytes() {
        long freeDiskInKb = 0L;
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            try {
                FileStore store = Files.getFileStore(root);
                freeDiskInKb += store.getUsableSpace() / 1024L;
            }
            catch (IOException e) {
                freeDiskInKb += 0L;
            }
        }
        return freeDiskInKb;
    }
}

