/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class ReflectionUtil {
    public static Class<?> getNmsClass(String name) {
        String className = "net.minecraft.server." + name;
        if (ReflectionUtil.getClass(className) != null) {
            return ReflectionUtil.getClass(className);
        }
        className = "net.minecraft.server." + ReflectionUtil.getVersion() + "." + name;
        return ReflectionUtil.getClass(className);
    }

    public static Class<?> getCbClass(String name) {
        String className = "org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + "." + name;
        return ReflectionUtil.getClass(className);
    }

    public static Class<?> getUtilClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            try {
                return Class.forName("net.minecraft.util." + name);
            }
            catch (ClassNotFoundException ex2) {
                return null;
            }
        }
    }

    public static String getVersion() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    public static Object getHandle(Object wrapper) {
        Method getHandle = ReflectionUtil.makeMethod(wrapper.getClass(), "getHandle", new Class[0]);
        return ReflectionUtil.callMethod(getHandle, wrapper, new Object[0]);
    }

    public static Method makeMethod(Class<?> clazz, String methodName, Class<?> ... paramaters) {
        try {
            return clazz.getDeclaredMethod(methodName, paramaters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callMethod(Method method, Object instance, Object ... paramaters) {
        if (method == null) {
            throw new RuntimeException("No such method");
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(instance, paramaters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> Constructor<T> makeConstructor(Class<?> clazz, Class<?> ... paramaterTypes) {
        try {
            return clazz.getConstructor(paramaterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callConstructor(Constructor<T> constructor, Object ... paramaters) {
        if (constructor == null) {
            throw new RuntimeException("No such constructor");
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(paramaters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Field makeField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T getField(Field field, Object instance) {
        if (field == null) {
            throw new RuntimeException("No such field");
        }
        field.setAccessible(true);
        try {
            return (T)field.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setField(Field field, Object instance, Object value) {
        if (field == null) {
            throw new RuntimeException("No such field");
        }
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String name, Class<T> superClass) {
        try {
            return Class.forName(name).asSubclass(superClass);
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            return null;
        }
    }

    public static Field getOnlyField(Class<?> toGetFrom, Class<?> type) {
        Field only = null;
        for (Field field : toGetFrom.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getClass())) continue;
            Preconditions.checkArgument((only == null ? 1 : 0) != 0, (String)"More than one field of type %s on %s: %s and %s", (Object)type.getSimpleName(), (Object)toGetFrom.getSimpleName(), (Object)field.getName(), (Object)only.getName());
            only = field;
        }
        return only;
    }

    public static Method getOnlyMethod(Class<?> toGetFrom, Class<?> returnType, Class<?> ... paramSpec) {
        Method only = null;
        for (Method method : toGetFrom.getDeclaredMethods()) {
            if (!returnType.isAssignableFrom(method.getReturnType()) || !ReflectionUtil.isParamsMatchSpec(method.getParameterTypes(), paramSpec)) continue;
            Preconditions.checkArgument((only == null ? 1 : 0) != 0, (String)("More than one method matching spec on %s" + (only.getName().equals(method.getName()) ? "" : ": " + only.getName() + " " + method.getName())), (Object)toGetFrom.getSimpleName());
            only = method;
        }
        return only;
    }

    public static boolean isParamsMatchSpec(Class<?>[] parameters, Class<?> ... paramSpec) {
        if (parameters.length > paramSpec.length) {
            return false;
        }
        for (int i = 0; i < paramSpec.length; ++i) {
            Class<?> parameter;
            Class<?> spec = paramSpec[i];
            if (spec == null || spec.isAssignableFrom(parameter = parameters[i])) continue;
            return false;
        }
        return true;
    }
}

