/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import com.xinecraft.Minetrax;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PluginUtil {
    public static void unloadPlugin(Plugin plugin) {
        ClassLoader cl;
        String name = plugin.getName();
        PluginManager pluginManager = Bukkit.getPluginManager();
        SimpleCommandMap commandMap = null;
        List plugins = null;
        Map names = null;
        Map commands = null;
        Map listeners = null;
        boolean reloadListeners = true;
        pluginManager.disablePlugin(plugin);
        try {
            Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            plugins = (List)pluginsField.get(pluginManager);
            Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
            lookupNamesField.setAccessible(true);
            names = (Map)lookupNamesField.get(pluginManager);
            try {
                Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                listenersField.setAccessible(true);
                listeners = (Map)listenersField.get(pluginManager);
            }
            catch (Exception e) {
                reloadListeners = false;
            }
            Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            commands = (Map)knownCommandsField.get(commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        pluginManager.disablePlugin(plugin);
        if (plugins != null && plugins.contains(plugin)) {
            plugins.remove(plugin);
        }
        if (names != null && names.containsKey(name)) {
            names.remove(name);
        }
        if (listeners != null && reloadListeners) {
            for (SortedSet set : listeners.values()) {
                set.removeIf(value -> value.getPlugin() == plugin);
            }
        }
        if (commandMap != null) {
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                c.unregister(commandMap);
                it.remove();
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                Logger.getLogger(PluginUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.gc();
    }

    public static boolean checkIfPluginEnabled(String pluginName) {
        return PluginUtil.checkIfPluginEnabled(pluginName, true);
    }

    public static boolean checkIfPluginEnabled(String pluginName, boolean startsWith) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            boolean match;
            boolean bl = match = startsWith ? plugin.getName().toLowerCase().startsWith(pluginName.toLowerCase()) : plugin.getName().equalsIgnoreCase(pluginName);
            if (!match) continue;
            if (plugin.isEnabled()) {
                return true;
            }
            Minetrax.getPlugin().getLogger().info("Plugin " + plugin.getName() + " found but wasn't enabled. Returning false.");
            return false;
        }
        return false;
    }

    public static boolean pluginHookIsEnabled(String pluginName) {
        return PluginUtil.pluginHookIsEnabled(pluginName, true);
    }

    public static boolean pluginHookIsEnabled(String pluginName, boolean startsWith) {
        return PluginUtil.checkIfPluginEnabled(pluginName, startsWith);
    }

    public static Plugin getPlugin(String pluginName) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.getName().toLowerCase().startsWith(pluginName.toLowerCase())) continue;
            return plugin;
        }
        return null;
    }
}

