/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import com.xinecraft.Minetrax;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("GET", url, null, headers);
    }

    public static String post(String url, String body, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("POST", url, body, headers);
    }

    public static String post(String url, String body) throws IOException {
        return HttpUtil.post(url, body, null);
    }

    public static String postJson(String url, String jsonStr) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("Accept", "application/json");
        return HttpUtil.post(url, jsonStr, headers);
    }

    public static String postJsonWithAuth(String url, String jsonStr) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-KEY", Minetrax.getPlugin().getApiKey());
        headers.put("X-API-SECRET", Minetrax.getPlugin().getApiSecret());
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("Accept", "application/json");
        return HttpUtil.post(url, jsonStr, headers);
    }

    public static String postForm(String url, Map<String, String> params) throws IOException {
        return HttpUtil.postForm(url, params, null);
    }

    public static String postForm(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String body = "";
        if (params != null) {
            boolean first = true;
            for (String param : params.keySet()) {
                if (first) {
                    first = false;
                } else {
                    body = body + "&";
                }
                String value = params.get(param);
                body = body + URLEncoder.encode(param, "UTF-8") + "=";
                body = body + URLEncoder.encode(value, "UTF-8");
            }
        }
        return HttpUtil.post(url, body, headers);
    }

    public static String put(String url, String body, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("PUT", url, body, headers);
    }

    public static String put(String url, String body) throws IOException {
        return HttpUtil.put(url, body, null);
    }

    public static String delete(String url, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("DELETE", url, null, headers);
    }

    public static String delete(String url) throws IOException {
        return HttpUtil.delete(url, null);
    }

    public static String appendQueryParams(String url, Map<String, String> params) throws IOException {
        String fullUrl = url;
        if (params != null) {
            boolean first = fullUrl.indexOf(63) == -1;
            for (String param : params.keySet()) {
                if (first) {
                    fullUrl = fullUrl + '?';
                    first = false;
                } else {
                    fullUrl = fullUrl + '&';
                }
                String value = params.get(param);
                fullUrl = fullUrl + URLEncoder.encode(param, "UTF-8") + '=';
                fullUrl = fullUrl + URLEncoder.encode(value, "UTF-8");
            }
        }
        return fullUrl;
    }

    public static Map<String, String> getQueryParams(String url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        int start = url.indexOf(63);
        while (start != -1) {
            int equals = url.indexOf(61, start);
            String param = "";
            param = equals != -1 ? url.substring(start + 1, equals) : url.substring(start + 1);
            String value = "";
            if (equals != -1) {
                start = url.indexOf(38, equals);
                value = start != -1 ? url.substring(equals + 1, start) : url.substring(equals + 1);
            }
            params.put(URLDecoder.decode(param, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
        }
        return params;
    }

    public static String removeQueryParams(String url) throws IOException {
        int q = url.indexOf(63);
        if (q != -1) {
            return url.substring(0, q);
        }
        return url;
    }

    public static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(120000);
        conn.setReadTimeout(120000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.addRequestProperty(key, headers.get(key));
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
            os.flush();
            os.close();
        }
        InputStream is = conn.getInputStream();
        String response = HttpUtil.streamToString(is);
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            return HttpUtil.fetch(method, location, body, headers);
        }
        if (conn.getResponseCode() == 500) {
            Minetrax.getPlugin().getLogger().warning(response);
        }
        return response;
    }

    public static String streamToString(InputStream in) throws IOException {
        String data;
        InputStreamReader isr = new InputStreamReader(in, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        StringBuilder out = new StringBuilder();
        while ((data = br.readLine()) != null) {
            out.append(data);
        }
        br.close();
        return out.toString();
    }
}

