/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnsiColor {
    private static final String COLOR_PATTERN = "\u001b[38;5;%dm";
    private static final String FORMAT_PATTERN = "\u001b[%dm";

    public static String convertStringMessage(String message, char colorFormatter) {
        if (message != null && !message.isEmpty()) {
            String messageCopy = String.copyValueOf(message.toCharArray()) + ConsoleColor.RESET.ansiColor;
            Matcher matcher = Pattern.compile(String.format("(%c[0-9a-fk-or])(?!.*\u0001)", Character.valueOf(colorFormatter))).matcher(message);
            while (matcher.find()) {
                String result = matcher.group(1);
                ConsoleColor color = ConsoleColor.getColorByCode(result.charAt(1));
                messageCopy = messageCopy.replace(result, color.getAnsiColor());
            }
            return messageCopy;
        }
        return message;
    }

    private static enum ConsoleColor {
        BLACK('0', "\u001b[38;5;%dm", 0),
        DARK_GREEN('2', "\u001b[38;5;%dm", 2),
        DARK_RED('4', "\u001b[38;5;%dm", 1),
        GOLD('6', "\u001b[38;5;%dm", 172),
        DARK_GREY('8', "\u001b[38;5;%dm", 8),
        GREEN('a', "\u001b[38;5;%dm", 10),
        RED('c', "\u001b[38;5;%dm", 9),
        YELLOW('e', "\u001b[38;5;%dm", 11),
        DARK_BLUE('1', "\u001b[38;5;%dm", 4),
        DARK_AQUA('3', "\u001b[38;5;%dm", 30),
        DARK_PURPLE('5', "\u001b[38;5;%dm", 54),
        GRAY('7', "\u001b[38;5;%dm", 246),
        BLUE('9', "\u001b[38;5;%dm", 4),
        AQUA('b', "\u001b[38;5;%dm", 51),
        LIGHT_PURPLE('d', "\u001b[38;5;%dm", 13),
        WHITE('f', "\u001b[38;5;%dm", 15),
        STRIKETHROUGH('m', "\u001b[%dm", 9),
        ITALIC('o', "\u001b[%dm", 3),
        BOLD('l', "\u001b[%dm", 1),
        UNDERLINE('n', "\u001b[%dm", 4),
        RESET('r', "\u001b[%dm", 0),
        OBFUSCATED('k', "\u001b[%dm", 9);

        private char bukkitColor;
        private String ansiColor;

        private ConsoleColor(char bukkitColor, String pattern, int ansiCode) {
            this.bukkitColor = bukkitColor;
            this.ansiColor = String.format(pattern, ansiCode);
        }

        public static ConsoleColor getColorByCode(char code) {
            for (ConsoleColor color : ConsoleColor.values()) {
                if (color.bukkitColor != code) continue;
                return color;
            }
            throw new IllegalArgumentException("Color with code " + code + " does not exists");
        }

        public String getAnsiColor() {
            return this.ansiColor;
        }
    }
}

