/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.threads.webquery;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xinecraft.Minetrax;
import com.xinecraft.threads.data.QueryRequestData;
import com.xinecraft.utils.CryptoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WebQueryProtocol {
    public static String processInput(String theInput) {
        String theOutput = null;
        String apiSecret = Minetrax.getPlugin().getApiSecret().substring(0, 32);
        String decryptedInput = CryptoUtil.getDecryptedString(apiSecret, theInput);
        if (decryptedInput == null || decryptedInput.isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        QueryRequestData queryRequestData = (QueryRequestData)gson.fromJson(decryptedInput, QueryRequestData.class);
        if (!Minetrax.getPlugin().getApiKey().equals(queryRequestData.api_key)) {
            Minetrax.getPlugin().getLogger().warning("Error: API Key Mismatch");
            return null;
        }
        Minetrax.getPlugin().getLogger().info("Handing Query of Type: " + queryRequestData.type);
        switch (queryRequestData.type) {
            case "status": {
                theOutput = WebQueryProtocol.handleStatus();
                break;
            }
            case "user-say": {
                String[] strings = queryRequestData.params.split("\u00bd\u00bd\u00bd\u00bd");
                String messageFormat = Minetrax.getPlugin().getWebMessageFormat();
                String senderName = strings[0];
                String message = String.join((CharSequence)" ", Arrays.copyOfRange(strings, 1, strings.length));
                messageFormat = messageFormat.replace("{USERNAME}", senderName);
                messageFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)messageFormat);
                messageFormat = messageFormat.replace("{MESSAGE}", message);
                Bukkit.getServer().broadcastMessage(messageFormat);
                theOutput = "ok";
                break;
            }
            case "broadcast": {
                Bukkit.getServer().broadcastMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)queryRequestData.params));
                theOutput = "ok";
                break;
            }
            case "command": {
                boolean status = WebQueryProtocol.handleCommand(queryRequestData.params);
                if (!status) break;
                theOutput = "ok";
                break;
            }
            case "get-player-groups": {
                theOutput = WebQueryProtocol.getPlayerGroups(queryRequestData.params);
                break;
            }
        }
        return theOutput;
    }

    private static String getPlayerGroups(String uuid) {
        if (!Minetrax.getVaultPermission().hasGroupSupport()) {
            return CryptoUtil.getEncryptedString(Minetrax.getPlugin().getApiKey(), "{}");
        }
        UUID playerUuid = UUID.fromString(uuid);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
        if (!offlinePlayer.hasPlayedBefore()) {
            return CryptoUtil.getEncryptedString(Minetrax.getPlugin().getApiKey(), "{}");
        }
        String primaryGroup = Minetrax.getVaultPermission().getPrimaryGroup(null, offlinePlayer);
        String[] allGroups = Minetrax.getVaultPermission().getPlayerGroups(null, offlinePlayer);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("primary", primaryGroup);
        JsonArray jsonArray = new JsonArray();
        for (String g : allGroups) {
            jsonArray.add(g);
        }
        jsonObject.add("groups", (JsonElement)jsonArray);
        Gson gson = new Gson();
        String jsonString = gson.toJson((JsonElement)jsonObject);
        jsonString = CryptoUtil.getEncryptedString(Minetrax.getPlugin().getApiKey(), jsonString);
        return jsonString;
    }

    private static boolean handleCommand(String command) {
        try {
            boolean bl = (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)Minetrax.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String handleStatus() {
        JsonArray jsonArray = new JsonArray();
        ArrayList playerList = new ArrayList(Bukkit.getOnlinePlayers());
        for (Player player : playerList) {
            JsonObject playerJsonObject = new JsonObject();
            playerJsonObject.addProperty("username", player.getName());
            playerJsonObject.addProperty("id", player.getUniqueId().toString());
            playerJsonObject.addProperty("is_op", Boolean.valueOf(player.isOp()));
            playerJsonObject.addProperty("ping", (Number)player.getPing());
            playerJsonObject.addProperty("ip_address", Objects.requireNonNull(player.getAddress()).getHostString());
            jsonArray.add((JsonElement)playerJsonObject);
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson((JsonElement)jsonArray);
        jsonString = CryptoUtil.getEncryptedString(Minetrax.getPlugin().getApiKey(), jsonString);
        return jsonString;
    }
}

