/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.threads.webquery;

import com.xinecraft.Minetrax;
import com.xinecraft.threads.webquery.SimpleTCPChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.bukkit.scheduler.BukkitRunnable;

public class NettyWebQueryServer
extends BukkitRunnable {
    private int port;
    private String host;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;

    public NettyWebQueryServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void run() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new SimpleTCPChannelInitializer()).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = this.host != null && !this.host.isEmpty() ? b.bind(this.host, this.port).sync() : b.bind(this.port).sync();
            if (f.isSuccess()) {
                Minetrax.getPlugin().getLogger().info("WebQuery Server started successfully on port " + this.port);
                this.serverChannel = f.channel();
            }
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
        }
    }

    public void shutdown() {
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close().syncUninterruptibly();
            }
            catch (Exception e) {
                Minetrax.getPlugin().getLogger().warning("Unable to shutdown webquery channel! " + e.getMessage());
            }
        }
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        try {
            this.bossGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            this.workerGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

