/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.threads;

import com.xinecraft.Minetrax;
import com.xinecraft.log4j.ConsoleMessage;
import com.xinecraft.utils.HttpUtil;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ConsoleMessageQueueWorker
extends Thread {
    private static final char LINE_WRAP_INDENT = '\t';
    private static final long MIN_SLEEP_TIME_MILLIS = 2000L;
    private final StringBuilder message = new StringBuilder();
    private final Deque<ConsoleMessage> queue = Minetrax.getPlugin().getConsoleMessageQueue();

    public ConsoleMessageQueueWorker() {
        super("Minetrax - Console Message Queue Worker");
    }

    @Override
    public void run() {
        try {
            while (true) {
                long sleepTimeMS;
                ConsoleMessage consoleMessage;
                this.message.setLength(0);
                while ((consoleMessage = this.queue.peek()) != null) {
                    String formattedMessage = consoleMessage.toString();
                    this.message.append(formattedMessage).append("\r\n");
                    this.queue.poll();
                }
                String m = this.message.toString();
                if (StringUtils.isNotBlank((String)m)) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("api_key", Minetrax.getPlugin().getApiKey());
                    params.put("api_secret", Minetrax.getPlugin().getApiSecret());
                    params.put("log", m);
                    params.put("server_id", Minetrax.getPlugin().getApiServerId());
                    try {
                        HttpUtil.postForm(Minetrax.getPlugin().getApiHost() + "/api/v1/server/console", params);
                    }
                    catch (Exception e) {
                        this.queue.clear();
                    }
                }
                if ((sleepTimeMS = TimeUnit.SECONDS.toMillis(0L)) < 2000L) {
                    sleepTimeMS = 2000L;
                }
                Thread.sleep(sleepTimeMS);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

