/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xinecraft.Minetrax;
import com.xinecraft.data.PlayerSessionIntelData;
import com.xinecraft.utils.HttpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerIntelReportTask
implements Runnable {
    public final Gson gson = new GsonBuilder().serializeNulls().create();

    @Override
    public void run() {
        HashMap<String, PlayerSessionIntelData> playerSessionIntelDataMap = Minetrax.getPlugin().getPlayerSessionIntelDataMap();
        for (PlayerSessionIntelData playerSessionData : playerSessionIntelDataMap.values()) {
            Player onlinePlayer = Bukkit.getPlayer((UUID)UUID.fromString(playerSessionData.uuid));
            if (onlinePlayer != null && onlinePlayer.isOnline()) {
                playerSessionData.player_ping = onlinePlayer.getPing();
                playerSessionData.world_location = this.gson.toJson((Object)onlinePlayer.getLocation().serialize());
                playerSessionData.world_name = onlinePlayer.getWorld().getName();
                this.reportAndResetXminData(playerSessionData);
                continue;
            }
            this.reportAndRemoveSessionFromDataMap(playerSessionData);
        }
    }

    public void reportAndResetXminData(PlayerSessionIntelData playerSession) {
        String playerSessionDataJson = this.gson.toJson((Object)playerSession);
        try {
            Minetrax.getPlugin().getLogger().info("Reporting Periodic Session Data: " + playerSessionDataJson);
            HttpUtil.postJsonWithAuth(Minetrax.getPlugin().getApiHost() + "/api/v1/intel/player/report/event", playerSessionDataJson);
        }
        catch (Exception e) {
            Minetrax.getPlugin().getLogger().warning(e.getMessage());
        }
        playerSession.resetXminKeys();
    }

    private void reportAndRemoveSessionFromDataMap(PlayerSessionIntelData playerSession) {
        Minetrax.getPlugin().getLogger().info("REPORT FINAL SESSION END FOR RARE CASE OF SESSION STILL IN DATA WHEN PLAYER ALREADY OFF");
        playerSession.session_ended_at = new Date().getTime();
        String leftPlayerSessionDataJson = this.gson.toJson((Object)playerSession);
        Minetrax.getPlugin().playerSessionIntelDataMap.remove(playerSession.session_uuid);
        try {
            Minetrax.getPlugin().getLogger().info("Final Session Data: " + leftPlayerSessionDataJson);
            HttpUtil.postJsonWithAuth(Minetrax.getPlugin().getApiHost() + "/api/v1/intel/player/report/event", leftPlayerSessionDataJson);
        }
        catch (Exception e) {
            Minetrax.getPlugin().getLogger().warning(e.getMessage());
        }
    }
}

