/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.log4j;

import com.xinecraft.Minetrax;
import com.xinecraft.log4j.ConsoleMessage;
import com.xinecraft.utils.AnsiColor;
import com.xinecraft.utils.TimeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Mtx-ConsoleChannel", category="Core", elementType="appender", printObject=true)
public class ConsoleAppender
extends AbstractAppender {
    private static final PatternLayout PATTERN_LAYOUT;

    public ConsoleAppender() {
        super("Mtx-ConsoleChannel", null, (Layout)PATTERN_LAYOUT, false);
        Logger rootLogger = (Logger)LogManager.getRootLogger();
        rootLogger.addAppender((Appender)this);
    }

    public boolean isStarted() {
        return PATTERN_LAYOUT != null;
    }

    public void shutdown() {
        Logger rootLogger = (Logger)LogManager.getRootLogger();
        rootLogger.removeAppender((Appender)this);
    }

    public void append(LogEvent event) {
        Minetrax plugin = Minetrax.getPlugin();
        String eventLevel = event.getLevel().name().toUpperCase();
        String line = event.getMessage().getFormattedMessage();
        line = AnsiColor.convertStringMessage(line, '\u00a7');
        plugin.getConsoleMessageQueue().add(new ConsoleMessage(TimeUtil.timeStamp(), eventLevel, line));
    }

    static {
        Method createLayoutMethod = null;
        for (Method method : PatternLayout.class.getMethods()) {
            if (!method.getName().equals("createLayout")) continue;
            createLayoutMethod = method;
        }
        if (createLayoutMethod == null) {
            Minetrax.getPlugin().getLogger().warning("Failed to reflectively find the Log4j createLayout method. The console appender is not going to function.");
            PATTERN_LAYOUT = null;
        } else {
            Object[] args = new Object[createLayoutMethod.getParameterCount()];
            args[0] = "[%d{HH:mm:ss} %level]: %msg";
            if (args.length == 9) {
                args[5] = true;
                args[6] = true;
            }
            PatternLayout createdLayout = null;
            try {
                createdLayout = (PatternLayout)createLayoutMethod.invoke(null, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Minetrax.getPlugin().getLogger().warning("Failed to reflectively invoke the Log4j createLayout method. The console appender is not going to function.");
            }
            PATTERN_LAYOUT = createdLayout;
        }
    }
}

