/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xinecraft.Minetrax;
import com.xinecraft.data.PlayerData;
import com.xinecraft.data.PlayerDeathData;
import com.xinecraft.data.PlayerPvpKillData;
import com.xinecraft.data.PlayerSessionIntelData;
import com.xinecraft.utils.HttpUtil;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class EntityDeathEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        Player killer;
        PlayerData killerPlayerData;
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (event.getEntity() instanceof Player) {
            Player victim = (Player)event.getEntity();
            PlayerData victimPlayerData = Minetrax.getPlugin().playersDataMap.get(victim.getUniqueId().toString());
            if (victimPlayerData == null) {
                Minetrax.getPlugin().getLogger().warning("Failed to send death data. Cannot find player in playerData HashMap");
                return;
            }
            PlayerSessionIntelData victimSessionIntelData = Minetrax.getPlugin().playerSessionIntelDataMap.get(victimPlayerData.session_uuid);
            ++victimSessionIntelData.deaths;
            ++victimSessionIntelData.deaths_xmin;
            PlayerDeathData playerDeathData = new PlayerDeathData();
            playerDeathData.player_uuid = victim.getUniqueId().toString();
            playerDeathData.player_username = victim.getName();
            playerDeathData.died_at = new Date().getTime();
            playerDeathData.session_uuid = victimPlayerData.session_uuid;
            playerDeathData.world_name = victim.getWorld().getName();
            playerDeathData.world_location = gson.toJson((Object)victim.getLocation().serialize());
            String string = playerDeathData.cause = victim.getLastDamageCause() != null ? victim.getLastDamageCause().getCause().name() : null;
            if (event.getEntity().getKiller() != null) {
                Player killer2 = event.getEntity().getKiller();
                playerDeathData.killer_uuid = killer2.getUniqueId().toString();
                playerDeathData.killer_username = killer2.getName();
                PlayerData killerPlayerData2 = Minetrax.getPlugin().playersDataMap.get(killer2.getUniqueId().toString());
                if (killerPlayerData2 != null) {
                    PlayerSessionIntelData killerSessionIntelData = Minetrax.getPlugin().playerSessionIntelDataMap.get(killerPlayerData2.session_uuid);
                    ++killerSessionIntelData.player_kills;
                    ++killerSessionIntelData.player_kills_xmin;
                    PlayerPvpKillData playerPvpKillData = new PlayerPvpKillData();
                    playerPvpKillData.killer_uuid = killer2.getUniqueId().toString();
                    playerPvpKillData.killer_username = killer2.getName();
                    playerPvpKillData.victim_uuid = victim.getUniqueId().toString();
                    playerPvpKillData.victim_username = victim.getName();
                    playerPvpKillData.killed_at = new Date().getTime();
                    playerPvpKillData.session_uuid = killerPlayerData2.session_uuid;
                    playerPvpKillData.world_name = killer2.getWorld().getName();
                    playerPvpKillData.world_location = gson.toJson((Object)killer2.getLocation().serialize());
                    playerPvpKillData.weapon = killer2.getInventory().getItemInMainHand().getType().toString();
                    final String playerPvpKillDataJSON = gson.toJson((Object)playerPvpKillData);
                    Minetrax.getPlugin().getLogger().info("---SENDING PLAYER PVP KILL REPORT---");
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Minetrax.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                HttpUtil.postJsonWithAuth(Minetrax.getPlugin().getApiHost() + "/api/v1/intel/player/report/pvp-kill", playerPvpKillDataJSON);
                            }
                            catch (Exception e) {
                                Minetrax.getPlugin().getLogger().warning(e.getMessage());
                            }
                        }
                    });
                }
            } else if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent lastDamageCause = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause();
                playerDeathData.killer_entity_id = lastDamageCause.getDamager().getType().toString();
                playerDeathData.killer_entity_name = lastDamageCause.getDamager().getName();
            }
            Minetrax.getPlugin().getLogger().info("---SENDING PLAYER DEATH REPORT---");
            final String playerDeathJSON = gson.toJson((Object)playerDeathData);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Minetrax.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpUtil.postJsonWithAuth(Minetrax.getPlugin().getApiHost() + "/api/v1/intel/player/report/death", playerDeathJSON);
                    }
                    catch (Exception e) {
                        Minetrax.getPlugin().getLogger().warning(e.getMessage());
                    }
                }
            });
        } else if (event.getEntity().getKiller() != null && (killerPlayerData = Minetrax.getPlugin().playersDataMap.get((killer = event.getEntity().getKiller()).getUniqueId().toString())) != null) {
            PlayerSessionIntelData killerSessionIntelData = Minetrax.getPlugin().playerSessionIntelDataMap.get(killerPlayerData.session_uuid);
            ++killerSessionIntelData.mob_kills;
            ++killerSessionIntelData.mob_kills_xmin;
        }
    }
}

