/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft.commands;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xinecraft.Minetrax;
import com.xinecraft.utils.HttpUtil;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AccountLinkCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!(commandSender instanceof Player)) {
            Minetrax.getPlugin().getLogger().info("Error: Only players can execute that command.");
            return false;
        }
        final Player player = (Player)commandSender;
        player.sendMessage(ChatColor.GRAY + "Please wait.. Account verification is instantiating.");
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", Minetrax.getPlugin().getApiKey());
        params.put("api_secret", Minetrax.getPlugin().getApiSecret());
        params.put("uuid", player.getUniqueId().toString());
        params.put("server_id", Minetrax.getPlugin().getApiServerId());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Minetrax.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    String response = HttpUtil.postForm(Minetrax.getPlugin().getApiHost() + "/api/v1/account-link/init", params);
                    JsonObject responseObj = new JsonParser().parse(response).getAsJsonObject();
                    if (responseObj.get("status").getAsString().equals("error")) {
                        String errorType = responseObj.get("type").getAsString();
                        if (errorType.equals("not-found")) {
                            player.sendMessage(ChatColor.RED + "404! Player not in website database yet.");
                            player.sendMessage(ChatColor.YELLOW + "Please try again after an hour");
                        } else if (errorType.equals("player-already-linked")) {
                            player.sendMessage(ChatColor.YELLOW + "Hey! This player is already linked. Plz visit " + ChatColor.UNDERLINE + Minetrax.getPlugin().getApiHost() + ChatColor.RESET + ChatColor.YELLOW + " to know more.");
                        } else {
                            player.sendMessage(ChatColor.RED + "Some unknown error occurred. Please try again after some time.");
                        }
                        return;
                    }
                    if (responseObj.get("status").getAsString().equals("success")) {
                        String url = responseObj.get("data").getAsString();
                        player.sendMessage(ChatColor.GREEN + "Please open the below link to start your linking process");
                        player.sendMessage(url);
                    }
                }
                catch (Exception e) {
                    player.sendMessage(ChatColor.RED + "Some unknown error occurred. Please try again after some time.");
                }
            }
        });
        return false;
    }
}

