/*
 * Decompiled with CFR 0.152.
 */
package com.xinecraft;

import com.xinecraft.bukkit.Metrics;
import com.xinecraft.commands.AccountLinkCommand;
import com.xinecraft.commands.PlayerWhoisCommand;
import com.xinecraft.commands.WebSayCommand;
import com.xinecraft.data.PlayerData;
import com.xinecraft.data.PlayerSessionIntelData;
import com.xinecraft.hooks.chat.VentureChatHook;
import com.xinecraft.listeners.BlockBreakListener;
import com.xinecraft.listeners.BlockPlaceListener;
import com.xinecraft.listeners.EntityDeathEventListener;
import com.xinecraft.listeners.EntityPickupItemListener;
import com.xinecraft.listeners.PlayerAdvancementDoneListener;
import com.xinecraft.listeners.PlayerChatListener;
import com.xinecraft.listeners.PlayerCommandListener;
import com.xinecraft.listeners.PlayerDeathListener;
import com.xinecraft.listeners.PlayerDropItemListener;
import com.xinecraft.listeners.PlayerItemBreakListener;
import com.xinecraft.listeners.PlayerItemConsumeListener;
import com.xinecraft.listeners.PlayerJoinLeaveListener;
import com.xinecraft.listeners.PlayerKickBanListener;
import com.xinecraft.listeners.PlayerMoveListener;
import com.xinecraft.listeners.ServerBroadcastListener;
import com.xinecraft.log4j.ConsoleAppender;
import com.xinecraft.log4j.ConsoleMessage;
import com.xinecraft.tasks.AccountLinkReminderTask;
import com.xinecraft.tasks.PlayerAfkAndWorldIntelTrackerTask;
import com.xinecraft.tasks.PlayerIntelReportTask;
import com.xinecraft.tasks.ServerIntelReportTask;
import com.xinecraft.threads.ConsoleMessageQueueWorker;
import com.xinecraft.threads.webquery.NettyWebQueryServer;
import com.xinecraft.utils.PluginUtil;
import com.xinecraft.utils.UpdateChecker;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Minetrax
extends JavaPlugin
implements Listener {
    private ConsoleMessageQueueWorker consoleMessageQueueWorker;
    private NettyWebQueryServer webQuerySocketServer;
    private final Deque<ConsoleMessage> consoleMessageQueue = new LinkedList<ConsoleMessage>();
    private ConsoleAppender consoleAppender;
    private Boolean isEnabled;
    private String apiKey;
    private String apiSecret;
    private String apiServerId;
    private String apiHost;
    private Boolean isChatLogEnabled;
    private Boolean isConsoleLogEnabled;
    private String webQueryHost;
    private int webQueryPort;
    private String webMessageFormat;
    private Boolean isWhoisOnPlayerJoinEnabled;
    private Boolean isWhoisOnCommandEnabled;
    private String whoisNoMatchFoundMessage;
    private List<String> whoisPlayerOnJoinMessage;
    private List<String> whoisPlayerOnFirstJoinMessage;
    private List<String> whoisPlayerOnCommandMessage;
    private Boolean isFireworkOnPlayerJoin;
    private Boolean isFireworkOnPlayerFirstJoin;
    private String fireworkSendAmount;
    private String whoisAdminPermissionName;
    private List<String> whoisPlayerOnAdminCommandMessage;
    private String whoisMultiplePlayersTitleMessage;
    private String whoisMultiplePlayersListMessage;
    private Boolean isRemindPlayerToLinkEnabled;
    private Boolean isServerIntelEnabled;
    private Boolean isPlayerIntelEnabled;
    private Long remindPlayerToLinkInterval;
    private List<String> remindPlayerToLinkMessage;
    private long afkThresholdInMs;
    public HashMap<String, PlayerData> playersDataMap;
    public HashMap<String, PlayerSessionIntelData> playerSessionIntelDataMap;
    public String serverSessionId;
    private static Permission perms = null;

    public static Minetrax getPlugin() {
        return (Minetrax)Minetrax.getPlugin(Minetrax.class);
    }

    public void onEnable() {
        this.getLogger().info("Minetrax Plugin Enabled!");
        int pluginId = 15485;
        Metrics metrics = new Metrics(this, pluginId);
        this.playersDataMap = new HashMap();
        this.playerSessionIntelDataMap = new HashMap();
        this.saveDefaultConfig();
        this.isEnabled = this.getConfig().getBoolean("enabled");
        if (!this.isEnabled.booleanValue()) {
            this.getLogger().warning("Plugin disabled from config.yml");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.apiHost = this.getConfig().getString("api-host");
        if (this.apiHost != null) {
            this.apiHost = StringUtils.strip((String)this.apiHost, (String)"/");
        }
        this.apiKey = this.getConfig().getString("api-key");
        this.apiSecret = this.getConfig().getString("api-secret");
        this.apiServerId = this.getConfig().getString("server-id");
        this.isChatLogEnabled = this.getConfig().getBoolean("enable-chatlog");
        this.isConsoleLogEnabled = this.getConfig().getBoolean("enable-consolelog");
        this.webQueryHost = this.getConfig().getString("webquery-host");
        this.webQueryPort = this.getConfig().getInt("webquery-port");
        this.webMessageFormat = this.getConfig().getString("web-message-format");
        this.isWhoisOnPlayerJoinEnabled = this.getConfig().getBoolean("enable-whois-on-player-join");
        this.isWhoisOnCommandEnabled = this.getConfig().getBoolean("enable-whois-on-command");
        this.whoisNoMatchFoundMessage = this.getConfig().getString("whois-no-match-found-message");
        this.whoisPlayerOnJoinMessage = this.getConfig().getStringList("whois-player-on-join-message");
        this.whoisPlayerOnFirstJoinMessage = this.getConfig().getStringList("whois-player-on-first-join-message");
        this.whoisPlayerOnCommandMessage = this.getConfig().getStringList("whois-player-on-command-message");
        this.whoisAdminPermissionName = this.getConfig().getString("whois-admin-permission-name");
        this.whoisPlayerOnAdminCommandMessage = this.getConfig().getStringList("whois-player-on-admin-command-message");
        this.whoisMultiplePlayersTitleMessage = this.getConfig().getString("whois-multiple-players-title-message");
        this.whoisMultiplePlayersListMessage = this.getConfig().getString("whois-multiple-players-list-message");
        this.isRemindPlayerToLinkEnabled = this.getConfig().getBoolean("remind-player-to-link");
        this.isServerIntelEnabled = this.getConfig().getBoolean("report-server-intel");
        this.isPlayerIntelEnabled = this.getConfig().getBoolean("report-player-intel");
        this.remindPlayerToLinkInterval = this.getConfig().getLong("remind-player-interval");
        this.remindPlayerToLinkMessage = this.getConfig().getStringList("remind-player-link-message");
        this.afkThresholdInMs = this.getConfig().getLong("afk-threshold-in-seconds", 300L) * 1000L;
        this.isFireworkOnPlayerJoin = this.getConfig().getBoolean("enable-firework-on-player-join");
        this.isFireworkOnPlayerFirstJoin = this.getConfig().getBoolean("enable-firework-on-player-first-join");
        this.fireworkSendAmount = this.getConfig().getString("join-fireworks-amount");
        this.serverSessionId = UUID.randomUUID().toString();
        if (this.apiHost == null || this.apiKey == null || this.apiSecret == null || this.apiServerId == null || this.apiHost.isEmpty() || this.apiKey.isEmpty() || this.apiSecret.isEmpty() || this.apiServerId.isEmpty()) {
            this.getLogger().warning("Plugin disabled due to no API information");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getCommand("link-account").setExecutor((CommandExecutor)new AccountLinkCommand());
        this.getCommand("websay").setExecutor((CommandExecutor)new WebSayCommand());
        this.getCommand("ww").setExecutor((CommandExecutor)new PlayerWhoisCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerAdvancementDoneListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinLeaveListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerKickBanListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ServerBroadcastListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDeathEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDropItemListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityPickupItemListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerItemBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerItemConsumeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandListener(), (Plugin)this);
        if (this.isChatLogEnabled.booleanValue() && PluginUtil.checkIfPluginEnabled("VentureChat")) {
            this.getLogger().info("Venture Chat is found! Adding Hook...");
            this.getServer().getPluginManager().registerEvents((Listener)new VentureChatHook(), (Plugin)this);
        }
        if (this.isConsoleLogEnabled.booleanValue()) {
            this.consoleAppender = new ConsoleAppender();
            if (this.consoleMessageQueueWorker != null) {
                if (this.consoleMessageQueueWorker.getState() != Thread.State.NEW) {
                    this.consoleMessageQueueWorker.interrupt();
                    this.consoleMessageQueueWorker = new ConsoleMessageQueueWorker();
                }
            } else {
                this.consoleMessageQueueWorker = new ConsoleMessageQueueWorker();
            }
            this.consoleMessageQueueWorker.start();
        }
        this.webQuerySocketServer = new NettyWebQueryServer(this.webQueryHost, this.webQueryPort);
        this.webQuerySocketServer.runTaskAsynchronously((Plugin)this);
        boolean hasVaultPermission = this.setupVaultPermission();
        if (!hasVaultPermission) {
            this.getLogger().info("No Vault supported permission plugin found.");
        } else {
            this.getLogger().info("Vault Permission Plugin: " + perms.getName());
        }
        if (this.isRemindPlayerToLinkEnabled.booleanValue()) {
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new AccountLinkReminderTask(), 400L, this.remindPlayerToLinkInterval * 20L);
        }
        if (this.isServerIntelEnabled.booleanValue()) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ServerIntelReportTask(), 1200L, 1200L);
        }
        if (this.isPlayerIntelEnabled.booleanValue()) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new PlayerIntelReportTask(), 6000L, 6000L);
        }
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new PlayerAfkAndWorldIntelTrackerTask(), 20L, 20L);
        this.checkForPluginUpdates();
    }

    public void onDisable() {
        this.getLogger().info("Minetrax Plugin Disabled!");
        HandlerList.unregisterAll();
        this.webQuerySocketServer.shutdown();
    }

    private boolean setupVaultPermission() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    private void checkForPluginUpdates() {
        new UpdateChecker(this, 102635).getVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.getLogger().info("You are currently running the latest version of Minetrax");
            } else {
                this.getLogger().info("There is a new update available. Please update to latest version.");
            }
        });
    }

    public static Permission getVaultPermission() {
        return perms;
    }

    public ConsoleMessageQueueWorker getConsoleMessageQueueWorker() {
        return this.consoleMessageQueueWorker;
    }

    public NettyWebQueryServer getWebQuerySocketServer() {
        return this.webQuerySocketServer;
    }

    public Deque<ConsoleMessage> getConsoleMessageQueue() {
        return this.consoleMessageQueue;
    }

    public ConsoleAppender getConsoleAppender() {
        return this.consoleAppender;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getApiServerId() {
        return this.apiServerId;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public Boolean getIsChatLogEnabled() {
        return this.isChatLogEnabled;
    }

    public Boolean getIsConsoleLogEnabled() {
        return this.isConsoleLogEnabled;
    }

    public String getWebQueryHost() {
        return this.webQueryHost;
    }

    public int getWebQueryPort() {
        return this.webQueryPort;
    }

    public String getWebMessageFormat() {
        return this.webMessageFormat;
    }

    public Boolean getIsWhoisOnPlayerJoinEnabled() {
        return this.isWhoisOnPlayerJoinEnabled;
    }

    public Boolean getIsWhoisOnCommandEnabled() {
        return this.isWhoisOnCommandEnabled;
    }

    public String getWhoisNoMatchFoundMessage() {
        return this.whoisNoMatchFoundMessage;
    }

    public List<String> getWhoisPlayerOnJoinMessage() {
        return this.whoisPlayerOnJoinMessage;
    }

    public List<String> getWhoisPlayerOnFirstJoinMessage() {
        return this.whoisPlayerOnFirstJoinMessage;
    }

    public List<String> getWhoisPlayerOnCommandMessage() {
        return this.whoisPlayerOnCommandMessage;
    }

    public Boolean getIsFireworkOnPlayerJoin() {
        return this.isFireworkOnPlayerJoin;
    }

    public Boolean getIsFireworkOnPlayerFirstJoin() {
        return this.isFireworkOnPlayerFirstJoin;
    }

    public String getFireworkSendAmount() {
        return this.fireworkSendAmount;
    }

    public String getWhoisAdminPermissionName() {
        return this.whoisAdminPermissionName;
    }

    public List<String> getWhoisPlayerOnAdminCommandMessage() {
        return this.whoisPlayerOnAdminCommandMessage;
    }

    public String getWhoisMultiplePlayersTitleMessage() {
        return this.whoisMultiplePlayersTitleMessage;
    }

    public String getWhoisMultiplePlayersListMessage() {
        return this.whoisMultiplePlayersListMessage;
    }

    public Boolean getIsRemindPlayerToLinkEnabled() {
        return this.isRemindPlayerToLinkEnabled;
    }

    public Boolean getIsServerIntelEnabled() {
        return this.isServerIntelEnabled;
    }

    public Boolean getIsPlayerIntelEnabled() {
        return this.isPlayerIntelEnabled;
    }

    public Long getRemindPlayerToLinkInterval() {
        return this.remindPlayerToLinkInterval;
    }

    public List<String> getRemindPlayerToLinkMessage() {
        return this.remindPlayerToLinkMessage;
    }

    public long getAfkThresholdInMs() {
        return this.afkThresholdInMs;
    }

    public HashMap<String, PlayerData> getPlayersDataMap() {
        return this.playersDataMap;
    }

    public HashMap<String, PlayerSessionIntelData> getPlayerSessionIntelDataMap() {
        return this.playerSessionIntelDataMap;
    }

    public String getServerSessionId() {
        return this.serverSessionId;
    }
}

