/*
 * Decompiled with CFR 0.152.
 */
package net.hypple.plugin.datamanager.bungee;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import net.hypple.plugin.datamanager.bungee.DataManagerLoadedEvent;
import net.hypple.plugin.datamanager.data.MySQL;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class DataManager
extends Plugin {
    MySQL mysql;

    public void onEnable() {
        this.mysql = new MySQL();
        Configuration config = this.GetDefaultConfig();
        String host = config.getString("mysql.host");
        String database = config.getString("mysql.database");
        String username = config.getString("mysql.username");
        String password = config.getString("mysql.password");
        int port = config.getInt("mysql.port");
        this.mysql.Login(host, database, username, password, port);
        BungeeCord.getInstance().pluginManager.callEvent((Event)new DataManagerLoadedEvent(this));
    }

    public Connection GetConnection() {
        return this.mysql.GetConnection();
    }

    private Configuration GetDefaultConfig() {
        File file = new File(this.getDataFolder(), "config.yml");
        try {
            if (!file.exists()) {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdir();
                }
                file.createNewFile();
                Throwable localThrowable6 = null;
                try (InputStream is = this.getResourceAsStream("config.yml");){
                    try {
                        FileOutputStream os = new FileOutputStream(file);
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable localThrowable4) {
                        localThrowable6 = localThrowable4;
                        throw localThrowable4;
                    }
                }
            }
            return ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

