/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.thesnipe12.utilities.CustomConfig;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;

public class PluginUtilities {
    public static void sendConfigMessage(String path, Plugin plugin, Player player, String replacement) {
        if (plugin.getConfig().getString(path, "").isEmpty()) {
            return;
        }
        if (replacement == null) {
            replacement = "%player%";
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(plugin.getConfig().getString("prefix", "") + plugin.getConfig().getString(path))).replace("%player%", replacement));
    }

    public static void broadcastConfigMessage(String path, Plugin plugin, String replacement) {
        if (plugin.getConfig().getString(path, "").isEmpty()) {
            return;
        }
        if (replacement == null) {
            replacement = "%player%";
        }
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(plugin.getConfig().getString("prefix", "") + plugin.getConfig().getString(path))).replace("%player%", replacement));
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static void sendActionbar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    public static UUID getUUIDFromName(String name) {
        for (OfflinePlayer p : Bukkit.getServer().getOfflinePlayers()) {
            if (p.getName() == null || !p.getName().equalsIgnoreCase(name)) continue;
            return p.getUniqueId();
        }
        return null;
    }

    public static List<String> getOfflinePlayersAsStringList() {
        ArrayList<String> offlinePlayers = new ArrayList<String>();
        for (OfflinePlayer p : Bukkit.getServer().getOfflinePlayers()) {
            if (p.getName() == null) continue;
            offlinePlayers.add(p.getName());
        }
        return offlinePlayers;
    }

    public static List<String> getCommandOptions(List<String> availableOptions, String[] args) {
        String input = args[args.length - 1].toLowerCase();
        ArrayList<String> completions = new ArrayList<String>();
        for (String s : availableOptions) {
            if (!s.toLowerCase().startsWith(input)) continue;
            completions.add(s);
        }
        return completions;
    }

    public static boolean isListenerRegistered(Plugin plugin, Class<?> listenerClass) {
        boolean[] registered = new boolean[]{false};
        HandlerList.getRegisteredListeners((Plugin)plugin).forEach(listener -> {
            if (listenerClass.isInstance(listener.getListener())) {
                registered[0] = true;
            }
        });
        return registered[0];
    }

    public static CustomConfig getCustomConfig(ConfigType configType) {
        return configType.customConfig;
    }

    public static enum ConfigType {
        NEWBIE_CONFIG(new CustomConfig("newbieConfig.yml"));

        final CustomConfig customConfig;

        private ConfigType(CustomConfig customConfig) {
            this.customConfig = customConfig;
        }
    }
}

