/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.thesnipe12.listeners.ListenersConstants;
import me.thesnipe12.utilities.CustomConfig;
import me.thesnipe12.utilities.PluginUtilities;
import me.thesnipe12.utilities.UpdateChecker;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoggingListener
implements Listener {
    private final Plugin plugin;
    private final List<Player> kicked = new ArrayList<Player>();
    private final HashMap<Player, Integer> combatTimer;
    private final HashMap<Player, Player> lastHitter;

    public LoggingListener(Plugin plugin, HashMap<Player, Integer> combatTimer, HashMap<Player, Player> lastHitter) {
        this.plugin = plugin;
        this.combatTimer = combatTimer;
        this.lastHitter = lastHitter;
    }

    @EventHandler
    public void on(PlayerKickEvent event) {
        if (!this.plugin.getConfig().getBoolean("Timer.killOnKicks")) {
            this.kicked.add(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.combatTimer.putIfAbsent(player, 0);
        if (this.kicked.contains(event.getPlayer()) || this.combatTimer.get(player) == 0) {
            this.kicked.remove(event.getPlayer());
            return;
        }
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "kill " + player.getName());
        PluginUtilities.broadcastConfigMessage("Messages.CombatLoggedMessage", this.plugin, player.getName());
        this.combatTimer.put(player, 0);
        if (!this.lastHitter.containsKey(player)) {
            return;
        }
        this.removeHeartIfEnabled(player);
        this.giveHeartIfEnabled(this.lastHitter.get(player));
    }

    @EventHandler
    public void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.combatTimer.putIfAbsent(player, 0);
        CustomConfig newbieConfig = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG);
        if (!newbieConfig.getConfig().isSet("players." + player.getUniqueId()) && this.plugin.getConfig().getBoolean("newbieProtection.use")) {
            newbieConfig.getConfig().set("players." + player.getUniqueId(), (Object)0);
            newbieConfig.saveConfig();
        }
        this.sendNUPDMessageIfOperator(player);
    }

    private void sendNUPDMessageIfOperator(Player player) {
        if (!Bukkit.getServer().getOperators().contains(player)) {
            return;
        }
        new UpdateChecker(this.plugin, 101603).getVersion(version -> {
            if (!this.plugin.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                TextComponent prefix = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("prefix")));
                player.spigot().sendMessage(new BaseComponent[]{prefix, ListenersConstants.NUPD_MESSAGE_PART1, ListenersConstants.NUPD_MESSAGE_PART2, ListenersConstants.NUPD_MESSAGE_PART3});
            }
        });
    }

    private void removeHeartIfEnabled(Player player) {
        AttributeInstance playerAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (this.plugin.getConfig().getBoolean("LifeSteal.RemoveHeart") && playerAttribute != null) {
            playerAttribute.setBaseValue(playerAttribute.getValue() - 2.0);
        }
    }

    private void giveHeartIfEnabled(Player player) {
        AttributeInstance playerAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (this.plugin.getConfig().getBoolean("LifeSteal.GiveHeart") && playerAttribute != null) {
            playerAttribute.setBaseValue(playerAttribute.getValue() + 2.0);
        }
    }
}

