/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.listeners;

import java.util.HashMap;
import me.thesnipe12.utilities.PluginUtilities;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class CommandSendListener
implements Listener {
    private final Plugin plugin;
    private final HashMap<Player, Integer> combatTimer;

    public CommandSendListener(Plugin plugin, HashMap<Player, Integer> combatTimer) {
        this.plugin = plugin;
        this.combatTimer = combatTimer;
    }

    @EventHandler
    public void on(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        this.combatTimer.putIfAbsent(player, 0);
        if (this.combatTimer.get(player) == 0) {
            return;
        }
        String[] message = event.getMessage().split(" ");
        if (!this.isBannedCommand(message[0])) {
            return;
        }
        PluginUtilities.sendConfigMessage("Messages.NonAllowed", this.plugin, player, null);
        event.setCancelled(true);
    }

    private boolean isBannedCommand(String commandName) {
        for (String currentCommand : this.plugin.getConfig().getStringList("Timer.BannedCommands")) {
            if (currentCommand.equalsIgnoreCase("none")) {
                return false;
            }
            if (!("/" + currentCommand).equalsIgnoreCase(commandName)) continue;
            return true;
        }
        return false;
    }
}

