/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.listeners;

import java.util.HashMap;
import me.thesnipe12.utilities.PluginUtilities;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class CombatListener
implements Listener {
    private final Plugin plugin;
    private final HashMap<Player, Integer> combatTimer;
    private final HashMap<Player, Player> lastHitter;

    public CombatListener(Plugin plugin, HashMap<Player, Integer> combatTimer, HashMap<Player, Player> lastHitter) {
        this.plugin = plugin;
        this.combatTimer = combatTimer;
        this.lastHitter = lastHitter;
    }

    @EventHandler(ignoreCancelled=true)
    public void onNewbie(EntityDamageByEntityEvent event) {
        Entity damaged;
        if (!this.plugin.getConfig().getBoolean("newbieProtection.use")) {
            return;
        }
        Entity damager = event.getDamager();
        if (this.projectileToEntity(damager) != null) {
            damager = this.projectileToEntity(damager);
        }
        if (!this.areUniquePlayers(damager, damaged = event.getEntity(), true)) {
            return;
        }
        Entity newbie = this.getNewbie(damager, damaged);
        if (newbie == null) {
            return;
        }
        event.setCancelled(true);
        if (newbie == damager) {
            PluginUtilities.sendConfigMessage("Messages.whileNewbie", this.plugin, (Player)damager, damaged.getName());
        } else if (damager instanceof Player) {
            PluginUtilities.sendConfigMessage("Messages.hasNewbie", this.plugin, (Player)damager, damaged.getName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(EntityDamageByEntityEvent event) {
        Entity damaged;
        Entity damager = event.getDamager();
        if (this.projectileToEntity(damager) != null) {
            damager = this.projectileToEntity(damager);
        }
        if (!this.areUniquePlayers(damager, damaged = event.getEntity(), false)) {
            return;
        }
        this.combatTimer.putIfAbsent((Player)damaged, 0);
        if (damager instanceof Player) {
            this.combatTimer.putIfAbsent((Player)damager, 0);
            this.lastHitter.put((Player)damaged, (Player)damager);
            this.lastHitter.put((Player)damager, (Player)damaged);
            if (this.combatTimer.get(damager) == 0) {
                PluginUtilities.sendConfigMessage("Messages.TaggerMessage", this.plugin, (Player)damager, damaged.getName());
            }
            this.combatTimer.put((Player)damager, this.plugin.getConfig().getInt("Timer.CombatTime"));
        }
        if (this.combatTimer.get(damaged) == 0) {
            PluginUtilities.sendConfigMessage("Messages.TaggedMessage", this.plugin, (Player)damaged, damager.getName());
        }
        this.combatTimer.put((Player)damaged, this.plugin.getConfig().getInt("Timer.CombatTime"));
    }

    @EventHandler
    public void on(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.combatTimer.put(player, 0);
        if (event.getEntity().getKiller() != null) {
            return;
        }
        this.combatTimer.put(event.getEntity().getKiller(), 0);
    }

    private Entity getNewbie(Entity damager, Entity damaged) {
        int maxSeconds = this.plugin.getConfig().getInt("newbieProtection.seconds");
        int damagedSeconds = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG).getConfig().getInt("players." + damaged.getUniqueId());
        int damagerSeconds = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG).getConfig().getInt("players." + damager.getUniqueId());
        if (damagerSeconds < maxSeconds) {
            return damaged;
        }
        if (damagedSeconds < maxSeconds) {
            return damager;
        }
        return null;
    }

    private Entity projectileToEntity(Entity entity) {
        if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Entity) {
            ProjectileSource projectileSource = ((Projectile)entity).getShooter();
            return (Entity)projectileSource;
        }
        return null;
    }

    private boolean isEndCrystal(Entity entity, boolean forNewbie) {
        return (forNewbie ? !this.plugin.getConfig().getBoolean("newbieProtection.crystalsDamage") : this.plugin.getConfig().getBoolean("Timer.CrystalTag")) && entity instanceof EnderCrystal;
    }

    private boolean areUniquePlayers(Entity damager, Entity damaged, boolean forNewbie) {
        return (damager instanceof Player || this.isEndCrystal(damager, forNewbie)) && damaged instanceof Player && damager != damaged;
    }
}

