/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.thesnipe12.commands.CommandsConstants;
import me.thesnipe12.listeners.WorldGuardListener;
import me.thesnipe12.utilities.CustomConfig;
import me.thesnipe12.utilities.PluginUtilities;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SclreloadCommand
implements TabExecutor {
    private final Plugin plugin;
    private final HashMap<Player, Integer> combatTimer;

    public SclreloadCommand(Plugin plugin, HashMap<Player, Integer> combatTimer) {
        this.plugin = plugin;
        this.combatTimer = combatTimer;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("sclreload")) {
            return false;
        }
        if (!sender.hasPermission("simplecl.reload")) {
            sender.sendMessage(CommandsConstants.NO_PERMISSION);
            return true;
        }
        sender.sendMessage(CommandsConstants.RELOADING_CONFIG);
        this.reloadAllConfigs();
        this.reloadWorldGuard(sender);
        sender.sendMessage(CommandsConstants.RELOAD_SUCCESSFUL);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("sclreload")) {
            return null;
        }
        return new ArrayList<String>();
    }

    private void reloadWorldGuard(CommandSender sender) {
        if (this.plugin.getConfig().getBoolean("allowBorderHopping")) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuardEvents") == null) {
            sender.sendMessage("Border Hopping is not allowed but WorldGuardEvents is not found! got to https://www.spigotmc.org/resources/worldguard-events.65176/ to install it");
            return;
        }
        sender.sendMessage("WorldGuardEvents found! Border Hopping not allowed!");
        if (!PluginUtilities.isListenerRegistered(this.plugin, WorldGuardListener.class)) {
            Bukkit.getPluginManager().registerEvents((Listener)new WorldGuardListener(this.plugin, this.combatTimer), this.plugin);
        }
    }

    private void reloadAllConfigs() {
        this.plugin.reloadConfig();
        this.plugin.saveConfig();
        for (PluginUtilities.ConfigType configType : PluginUtilities.ConfigType.values()) {
            CustomConfig customConfig = PluginUtilities.getCustomConfig(configType);
            customConfig.reloadConfig();
            customConfig.saveConfig();
        }
    }
}

