/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.thesnipe12.commands.CommandsConstants;
import me.thesnipe12.utilities.CustomConfig;
import me.thesnipe12.utilities.PluginUtilities;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SclnewbieCommand
implements TabExecutor {
    private final Plugin plugin;

    public SclnewbieCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NonNull CommandSender sender, @NonNull Command command, @NonNull String label, @NonNull String[] args) {
        if (!command.getName().equalsIgnoreCase("sclnewbie")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(CommandsConstants.NEWBIE_WRONG_USAGE);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "set": {
                this.set(sender, args);
                break;
            }
            case "toggle": {
                this.toggle(sender);
                break;
            }
            case "remove": {
                this.remove(sender, args);
                break;
            }
            case "get": {
                this.get(sender, args);
                break;
            }
            default: {
                sender.sendMessage(CommandsConstants.NEWBIE_WRONG_USAGE);
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NonNull CommandSender sender, @NonNull Command command, @NonNull String label, @NonNull String[] args) {
        if (!command.getName().equalsIgnoreCase("sclnewbie")) {
            return null;
        }
        List<String> availableOptions = this.getAvailableOptions(sender, args);
        if (availableOptions.isEmpty()) {
            return availableOptions;
        }
        return PluginUtilities.getCommandOptions(availableOptions, args);
    }

    private List<String> getAvailableOptions(CommandSender sender, String[] args) {
        switch (args.length) {
            case 1: {
                if (sender.hasPermission("simplecl.newbie")) {
                    return CommandsConstants.NEWBIE_PERMS_OPTIONS;
                }
                return CommandsConstants.NEWBIE_OPTIONS;
            }
            case 2: {
                if (sender.hasPermission("simplecl.newbie") && CommandsConstants.NEWBIE_PERMS_OPTIONS.contains(args[0].toLowerCase()) && !args[0].equalsIgnoreCase("toggle")) {
                    return PluginUtilities.getOfflinePlayersAsStringList();
                }
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    private void get(CommandSender sender, String[] args) {
        UUID uuid;
        if (!this.plugin.getConfig().getBoolean("newbieProtection.use")) {
            sender.sendMessage(CommandsConstants.NEWBIE_DISABLED);
            return;
        }
        int maxSeconds = this.plugin.getConfig().getInt("newbieProtection.seconds");
        CustomConfig newbieConfig = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG);
        if (args.length >= 2 && sender.hasPermission("simplecl.newbie") && PluginUtilities.getUUIDFromName(args[1]) != null) {
            uuid = PluginUtilities.getUUIDFromName(args[1]);
        } else if (sender instanceof Player) {
            uuid = ((Player)sender).getUniqueId();
        } else {
            sender.sendMessage(CommandsConstants.ONLY_AVAILABLE_FOR_PLAYERS);
            return;
        }
        int seconds = newbieConfig.getConfig().getInt("players." + uuid);
        if (maxSeconds == seconds) {
            sender.sendMessage(CommandsConstants.NOT_NEWBIE_WITH_MAX_TIME.replace("%maxSeconds%", String.valueOf(maxSeconds)));
        } else {
            sender.sendMessage(CommandsConstants.MAX_NEWBIE_TIME.replace("%seconds%", String.valueOf(seconds)));
        }
    }

    private void remove(CommandSender sender, String[] args) {
        UUID uuid;
        if (!this.plugin.getConfig().getBoolean("newbieProtection.use")) {
            sender.sendMessage(CommandsConstants.NEWBIE_DISABLED);
            return;
        }
        int maxSeconds = this.plugin.getConfig().getInt("newbieProtection.seconds");
        CustomConfig newbieConfig = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG);
        if (args.length >= 2 && sender.hasPermission("simplecl.newbie") && PluginUtilities.getUUIDFromName(args[1]) != null) {
            uuid = PluginUtilities.getUUIDFromName(args[1]);
        } else if (sender instanceof Player) {
            uuid = ((Player)sender).getUniqueId();
        } else {
            sender.sendMessage(CommandsConstants.ONLY_AVAILABLE_FOR_PLAYERS);
            return;
        }
        int seconds = newbieConfig.getConfig().getInt("players." + uuid);
        if (maxSeconds == seconds) {
            sender.sendMessage(CommandsConstants.NOT_NEWBIE);
        } else {
            newbieConfig.getConfig().set("players." + uuid, (Object)maxSeconds);
            newbieConfig.saveConfig();
            sender.sendMessage(CommandsConstants.NOW_NOT_NEWBIE);
        }
    }

    private void toggle(CommandSender sender) {
        if (!sender.hasPermission("simplecl.newbie")) {
            sender.sendMessage(CommandsConstants.NO_PERMISSION);
            return;
        }
        this.plugin.getConfig().set("newbieProtection.use", (Object)(!this.plugin.getConfig().getBoolean("newbieProtection.use") ? 1 : 0));
        this.plugin.saveConfig();
        String state = this.plugin.getConfig().getBoolean("newbieProtection.use") ? "On" : "Off";
        sender.sendMessage(CommandsConstants.NEWBIE_NEW_STATE.replace("%state%", state));
    }

    private void set(CommandSender sender, String[] args) {
        if (!sender.hasPermission("simplecl.newbie")) {
            sender.sendMessage(CommandsConstants.NO_PERMISSION);
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(CommandsConstants.NEWBIE_WRONG_USAGE);
            return;
        }
        if (PluginUtilities.getUUIDFromName(args[1]) == null) {
            sender.sendMessage(CommandsConstants.NOT_IN_CACHE);
            return;
        }
        if (!PluginUtilities.isNumeric(args[2])) {
            sender.sendMessage(CommandsConstants.NEWBIE_WRONG_USAGE);
            return;
        }
        CustomConfig newbieConfig = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG);
        newbieConfig.getConfig().set("players." + PluginUtilities.getUUIDFromName(args[1]), (Object)Integer.parseInt(args[2]));
        newbieConfig.saveConfig();
        sender.sendMessage(CommandsConstants.COMMAND_SUCCESSFUL);
    }
}

