/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12;

import java.util.HashMap;
import me.thesnipe12.utilities.CustomConfig;
import me.thesnipe12.utilities.PluginUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timer
extends BukkitRunnable {
    private final Plugin plugin;
    private final HashMap<Player, Integer> combatTimer;

    public Timer(Plugin plugin, HashMap<Player, Integer> combatTimer) {
        this.plugin = plugin;
        this.combatTimer = combatTimer;
    }

    public void run() {
        for (Player player : this.combatTimer.keySet()) {
            if (this.combatTimer.get(player) <= 0 || player == null) continue;
            PluginUtilities.sendActionbar(player, this.plugin.getConfig().getString("Timer.ActionBarMessage") + this.plugin.getConfig().getString("Timer.NumberColor") + this.combatTimer.get(player));
            this.combatTimer.put(player, this.combatTimer.get(player) - 1);
            this.sendLastActionbarIfNeeded(player);
        }
        this.lowerNewbieTimerIfNeededForOnlinePlayers();
    }

    private void lowerNewbieTimerIfNeededForOnlinePlayers() {
        if (!this.plugin.getConfig().getBoolean("newbieProtection.use")) {
            return;
        }
        CustomConfig newbieConfig = PluginUtilities.getCustomConfig(PluginUtilities.ConfigType.NEWBIE_CONFIG);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!newbieConfig.getConfig().isSet("players." + p.getUniqueId())) {
                newbieConfig.getConfig().set("players." + p.getUniqueId(), (Object)0);
                newbieConfig.saveConfig();
                continue;
            }
            int maxSeconds = this.plugin.getConfig().getInt("newbieProtection.seconds");
            int seconds = newbieConfig.getConfig().getInt("players." + p.getUniqueId());
            if (seconds >= maxSeconds) continue;
            newbieConfig.getConfig().set("players." + p.getUniqueId(), (Object)(seconds + 1));
            newbieConfig.saveConfig();
        }
    }

    private void sendLastActionbarIfNeeded(Player player) {
        if (this.combatTimer.get(player) == 1) {
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                if (this.combatTimer.get(player) > 0) {
                    return;
                }
                PluginUtilities.sendActionbar(player, this.plugin.getConfig().getString("Timer.ActionBarMessage") + this.plugin.getConfig().getString("Timer.NumberColor") + this.combatTimer.get(player));
            }, 40L);
        }
    }
}

