/*
 * Decompiled with CFR 0.152.
 */
package me.thesnipe12;

import java.util.HashMap;
import java.util.List;
import me.thesnipe12.PluginConstants;
import me.thesnipe12.Timer;
import me.thesnipe12.commands.SclnewbieCommand;
import me.thesnipe12.commands.SclreloadCommand;
import me.thesnipe12.listeners.CombatListener;
import me.thesnipe12.listeners.CommandSendListener;
import me.thesnipe12.listeners.LoggingListener;
import me.thesnipe12.listeners.WorldGuardListener;
import me.thesnipe12.utilities.CustomConfig;
import me.thesnipe12.utilities.PluginUtilities;
import me.thesnipe12.utilities.UpdateChecker;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SimpleCL
extends JavaPlugin {
    private final HashMap<Player, Integer> combatTimer = new HashMap();
    private final HashMap<Player, Player> lastHitter = new HashMap();

    public void onEnable() {
        this.configsSetup();
        this.classesSetup();
        this.worldGuardSetup();
        this.commandsSetup();
        this.checkForUpdates();
        new Metrics((JavaPlugin)this, 17864);
    }

    private void configsSetup() {
        for (PluginUtilities.ConfigType configType : PluginUtilities.ConfigType.values()) {
            CustomConfig currentConfig = PluginUtilities.getCustomConfig(configType);
            currentConfig.setup();
            currentConfig.getConfig().options().copyDefaults(true);
            currentConfig.saveConfig();
        }
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    private void classesSetup() {
        new Timer((Plugin)this, this.combatTimer).runTaskTimer((Plugin)this, 0L, 20L);
        List<LoggingListener> listeners = List.of(new CommandSendListener((Plugin)this, this.combatTimer), new CombatListener((Plugin)this, this.combatTimer, this.lastHitter), new LoggingListener((Plugin)this, this.combatTimer, this.lastHitter));
        for (Listener listener : listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    private void worldGuardSetup() {
        if (!this.getConfig().getBoolean("allowBorderHopping")) {
            if (Bukkit.getPluginManager().getPlugin("WorldGuardEvents") != null) {
                this.getLogger().info("WorldGuardEvents found! Border Hopping not allowed!");
                Bukkit.getPluginManager().registerEvents((Listener)new WorldGuardListener((Plugin)this, this.combatTimer), (Plugin)this);
            } else {
                this.getLogger().warning("Border Hopping is not allowed but WorldGuardEvents is not found! got to https://www.spigotmc.org/resources/worldguard-events.65176/ to install it");
            }
        }
    }

    private void commandsSetup() {
        List<SclreloadCommand> commandClasses = List.of(new SclnewbieCommand((Plugin)this), new SclreloadCommand((Plugin)this, this.combatTimer));
        for (int i = commandClasses.size(); i > 0; --i) {
            PluginConstants.COMMANDS.get(i - 1).setExecutor((CommandExecutor)commandClasses.get(i - 1));
        }
    }

    private void checkForUpdates() {
        new UpdateChecker((Plugin)this, 101603).getVersion(version -> {
            if (!version.equalsIgnoreCase(this.getDescription().getVersion())) {
                this.getLogger().warning("There is a new version of the plugin available! Go to \"https://www.spigotmc.org/resources/simplecl.101603/\" to download it.");
            } else {
                this.getLogger().info("You are running the latest version of the plugin!");
            }
        });
    }
}

