/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtils {
    private static final Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);
    private static final Pattern mcTimePattern = Pattern.compile("(\\d\\d):(\\d\\d)");

    private TimeUtils() {
        throw new IllegalAccessError("TimeUtils should not be initialized");
    }

    public static long parseDateDiff(String time) throws IllegalArgumentException {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            for (int i = 0; i < m.groupCount(); ++i) {
                if (m.group(i) == null || m.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Could not parse Time!");
        }
        long timems = (long)years * 365L * 24L * 60L * 60L * 1000L;
        timems += (long)months * 30L * 24L * 60L * 60L * 1000L;
        timems += (long)weeks * 7L * 24L * 60L * 60L * 1000L;
        timems += (long)days * 24L * 60L * 60L * 1000L;
        timems += (long)hours * 60L * 60L * 1000L;
        timems += (long)minutes * 60L * 1000L;
        return timems += (long)seconds * 1000L;
    }

    public static String formatDateFromDiff(long datediff) {
        if (datediff < 1000L) {
            return "0s ";
        }
        long year = 31536000000L;
        long month = 2592000000L;
        long day = 86400000L;
        long hour = 3600000L;
        long minute = 60000L;
        long second = 1000L;
        long years = 0L;
        long months = 0L;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        Object time = "";
        long rdiff = datediff;
        if (rdiff > year) {
            years = rdiff / year;
            time = (String)time + String.valueOf(years) + " years ";
            rdiff -= years * year;
        }
        if (rdiff > month) {
            months = rdiff / month;
            time = (String)time + String.valueOf(months) + " months ";
            rdiff -= months * month;
        }
        if (rdiff > day) {
            days = rdiff / day;
            time = (String)time + String.valueOf(days) + " days ";
            rdiff -= days * day;
        }
        if (rdiff > hour) {
            hours = rdiff / hour;
            time = (String)time + String.valueOf(hours) + " hours ";
            rdiff -= hours * hour;
        }
        if (rdiff > minute) {
            minutes = rdiff / minute;
            time = (String)time + String.valueOf(minutes) + " minutes ";
            rdiff -= minutes * minute;
        }
        if (rdiff > second) {
            seconds = rdiff / second;
            time = (String)time + String.valueOf(seconds) + " seconds ";
            rdiff -= seconds * second;
        }
        return time;
    }

    public static long parseMCTime(String mcTime) {
        Matcher matcher = mcTimePattern.matcher(mcTime);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The time does not match the pattern 'hh:mm' : " + mcTime);
        }
        int hours = Integer.parseInt(matcher.group(1));
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Incorrect hours: " + hours);
        }
        int minutes = Integer.parseInt(matcher.group(2));
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Incorrect minutes: " + minutes);
        }
        return hours * 1000 + minutes * 1000 / 60;
    }

    public static String toMCTime(long time) {
        long hours = time / 1000L;
        long minutes = time % 1000L * 60L / 1000L;
        return String.format("%02d:%02d", hours, minutes);
    }

    public static long parseHoursAndMinutesToSeconds(String time) {
        Matcher matcher = mcTimePattern.matcher(time);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The time does not match the pattern 'hh:mm' : " + time);
        }
        int hours = Integer.parseInt(matcher.group(1));
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Incorrect hours: " + hours);
        }
        int minutes = Integer.parseInt(matcher.group(2));
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Incorrect minutes: " + minutes);
        }
        return hours * 3600 + minutes * 60;
    }

    public static String toIRLTime(long time) {
        long hours = time / 3600L;
        long minutes = time % 3600L / 60L;
        return String.format("%02d:%02d", hours, minutes);
    }
}

