/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.users;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.users.UserCache;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;

public class SimpleUserCache
implements UserCache {
    private static final String USER_CACHE_NAME = "usercache.json";
    private final IPeriodicHolographicDisplays phd;
    private final Map<UUID, String> idToName = new HashMap<UUID, String>();
    private final Map<String, UUID> nameToId = new HashMap<String, UUID>();

    public SimpleUserCache(IPeriodicHolographicDisplays phd) {
        this.phd = phd;
        this.populateUserCache(JsonParser.parseString((String)this.readUserCache()));
    }

    private String readUserCache() {
        StringBuilder contentBuilder = new StringBuilder();
        File wc = this.phd.getWorldContainer();
        String folderPath = wc != null ? wc.getPath() : ".";
        Path path = Paths.get(folderPath, USER_CACHE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            if (!folderPath.equalsIgnoreCase(".")) {
                folderPath = ".";
                path = Paths.get(folderPath, USER_CACHE_NAME);
                if (!Files.exists(path, new LinkOption[0])) {
                    if (this.phd instanceof JavaPlugin) {
                        this.phd.getLogger().warning("usercache.json not found!");
                    }
                    return "{}";
                }
            } else {
                if (this.phd instanceof JavaPlugin) {
                    this.phd.getLogger().warning("usercache.json not found!");
                }
                return "{}";
            }
        }
        this.phd.getLogger().info("Usercache found: " + path.toString());
        try (Stream<String> stream = Files.lines(path, StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            this.phd.getLogger().warning("No user cache found!");
        }
        return contentBuilder.toString();
    }

    private void populateUserCache(JsonElement json) {
        if (!json.isJsonArray()) {
            this.phd.getLogger().info("usercache.json was either empty or misconfigured");
            return;
        }
        JsonArray arr = json.getAsJsonArray();
        for (JsonElement el : arr) {
            UUID id;
            String name = el.getAsJsonObject().get("name").getAsString();
            String uuid = el.getAsJsonObject().get("uuid").getAsString();
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException e) {
                this.phd.getLogger().severe("Unable to parse UUID from usercache.json: " + uuid);
                continue;
            }
            this.addOnStartup(id, name);
        }
    }

    void addOnStartup(UUID id, String name) {
        this.put(id, name, true);
    }

    private void put(UUID id, String name, boolean atStartup) {
        this.idToName.put(id, name);
        this.nameToId.put(name.toLowerCase(), id);
    }

    @Override
    public boolean isEmpty() {
        return this.idToName.isEmpty();
    }

    @Override
    public UUID getUuid(String name) {
        return this.nameToId.get(name.toLowerCase());
    }

    @Override
    public String getName(UUID id) {
        return this.idToName.get(id);
    }

    @Override
    public void setAll(Map<UUID, String> map) {
        for (Map.Entry<UUID, String> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void set(UUID id, String name) {
        this.put(id, name, false);
    }

    @Override
    public List<String> getNamesStartingWith(String start) {
        ArrayList<String> list = new ArrayList<String>();
        if (start.length() < 2) {
            return list;
        }
        return (List)StringUtil.copyPartialMatches((String)start, this.idToName.values(), list);
    }

    @Override
    public Map<UUID, String> getEntireCache() {
        return new HashMap<UUID, String>(this.idToName);
    }
}

