/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.storage.yaml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CustomConfigHandler {
    private final IPeriodicHolographicDisplays phd;
    private final String fileName;
    private final boolean noSave;
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;

    public CustomConfigHandler(IPeriodicHolographicDisplays phd, String name) throws InvalidConfigurationException {
        this(phd, name, false);
    }

    public CustomConfigHandler(IPeriodicHolographicDisplays phd, String name, boolean noSave) throws InvalidConfigurationException {
        this.phd = phd;
        this.fileName = name;
        this.noSave = noSave;
        this.saveDefaultConfig();
        this.reloadConfig();
    }

    public boolean reloadConfig() throws InvalidConfigurationException {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.phd.getDataFolder(), this.fileName);
        }
        this.customConfig = CustomConfigHandler.loadConfiguration(this.customConfigFile);
        InputStreamReader defConfigStream = null;
        InputStream resource = this.phd.getResource(this.fileName);
        if (resource != null) {
            try {
                defConfigStream = new InputStreamReader(resource, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(defConfigStream);
            this.customConfig.setDefaults((Configuration)defConfig);
        }
        if (this.customConfig.getKeys(true).isEmpty()) {
            if (!this.noSave) {
                this.saveConfig();
            }
            return false;
        }
        return true;
    }

    public File getFile() {
        return this.customConfigFile;
    }

    public FileConfiguration getConfig() {
        return this.customConfig;
    }

    public void saveConfig() {
        if (this.customConfig == null || this.customConfigFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.customConfigFile);
        }
        catch (IOException ex) {
            this.phd.getLogger().log(Level.SEVERE, "Could not save config to " + this.customConfigFile, ex);
        }
    }

    public void saveDefaultConfig() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.phd.getDataFolder(), this.fileName);
        }
        if (!this.customConfigFile.exists() && this.phd.getResource(this.fileName) != null) {
            this.phd.saveResource(this.fileName, false);
        }
    }

    public static YamlConfiguration loadConfiguration(File file) throws InvalidConfigurationException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }
}

