/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.listeners;

import java.util.function.Consumer;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PerChunkListener
implements Listener {
    private final World world;
    private final Consumer<Chunk> chunkLoad;
    private final Consumer<Chunk> chunkUnload;

    public PerChunkListener(IPeriodicHolographicDisplays phd, PluginManager pm, World world, Consumer<Chunk> chunkLoad, Consumer<Chunk> chunkUnload) {
        Validate.notNull((Object)world, (String)"Cannot listen for null world");
        Validate.notNull(chunkLoad, (String)"The loading consumer cannot be null");
        Validate.notNull(chunkUnload, (String)"The unloading consumer cannot be null");
        this.world = world;
        this.chunkLoad = chunkLoad;
        this.chunkUnload = chunkUnload;
        pm.registerEvents((Listener)this, (Plugin)phd.asPlugin());
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (event.getWorld() != this.world) {
            return;
        }
        this.chunkLoad.accept(event.getChunk());
    }

    @EventHandler
    public void onChunkLoad(ChunkUnloadEvent event) {
        if (event.getWorld() != this.world) {
            return;
        }
        this.chunkUnload.accept(event.getChunk());
    }
}

