/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;

public interface Storage {
    public void saveHolograms(Set<HDHologramInfo> var1, boolean var2);

    public void loadHolograms(Consumer<HDHologramInfo> var1);

    public boolean hasData();

    public void clear();

    public static class HDHologramInfo {
        private final String holoName;
        private final List<HologramInfo> infos = new ArrayList<HologramInfo>();

        public HDHologramInfo(String holoName) {
            this.holoName = holoName;
        }

        public String getHoloName() {
            return this.holoName;
        }

        public void addInfo(HologramInfo info) {
            this.infos.add(info);
        }

        public boolean removeInfo(HologramInfo info) {
            return this.infos.remove(info);
        }

        public List<HologramInfo> getInfos() {
            return this.infos;
        }

        public String toString() {
            ArrayList<String> types = new ArrayList<String>();
            for (HologramInfo info : this.infos) {
                types.add(info.getType().name());
            }
            return String.format("[HDHoloInfo:%s(%s)]", this.holoName, this.infos.toString());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof HDHologramInfo)) {
                return false;
            }
            HDHologramInfo info = (HDHologramInfo)other;
            return this.holoName.equals(info.holoName) && this.infos.equals(info.infos);
        }
    }
}

