/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms.perchunk;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.ford.periodicholographicdisplays.holograms.IndividualHologramHandler;
import me.ford.periodicholographicdisplays.holograms.perchunk.HChunk;

public class PerChunkHologramHandler {
    private final Map<HChunk, Set<IndividualHologramHandler>> perChunkHandlers = new HashMap<HChunk, Set<IndividualHologramHandler>>();
    private final Map<IndividualHologramHandler, HChunk> chunksOfHandlers = new HashMap<IndividualHologramHandler, HChunk>();

    public void setChunkOf(IndividualHologramHandler handler, int x, int z) {
        this.removeFromChunk(handler);
        HChunk chunk = HChunk.of(x, z);
        this.addToChunk(chunk, handler);
    }

    public HChunk getChunkOf(IndividualHologramHandler handler) {
        return this.chunksOfHandlers.get(handler);
    }

    public Set<IndividualHologramHandler> getHandlersInChunk(int x, int z) {
        HChunk chunk = HChunk.of(x, z);
        Set<IndividualHologramHandler> set = this.perChunkHandlers.get(chunk);
        if (set == null) {
            return new HashSet<IndividualHologramHandler>();
        }
        return new HashSet<IndividualHologramHandler>(set);
    }

    private void removeFromChunk(IndividualHologramHandler handler) {
        Set<IndividualHologramHandler> set;
        HChunk prevChunk = this.chunksOfHandlers.remove(handler);
        if (prevChunk != null && (set = this.perChunkHandlers.get(prevChunk)) != null) {
            set.remove(handler);
        }
    }

    private void addToChunk(HChunk chunk, IndividualHologramHandler handler) {
        Set<IndividualHologramHandler> set = this.perChunkHandlers.get(chunk);
        if (set == null) {
            set = new HashSet<IndividualHologramHandler>();
            this.perChunkHandlers.put(chunk, set);
        }
        set.add(handler);
        this.chunksOfHandlers.put(handler, chunk);
    }
}

