/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.IndividualHologramHandler;
import me.ford.periodicholographicdisplays.holograms.perchunk.PerChunkHologramHandler;
import me.ford.periodicholographicdisplays.listeners.PerChunkListener;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.PluginManager;

public abstract class WorldHologramStorageBase {
    private final World world;
    private final IPeriodicHolographicDisplays phd;
    private final PluginManager pm;
    private final Map<String, IndividualHologramHandler> holograms = new HashMap<String, IndividualHologramHandler>();
    private final Set<IndividualHologramHandler> loadedHandlers = new HashSet<IndividualHologramHandler>();
    private final PerChunkHologramHandler perChunkHandler;

    WorldHologramStorageBase(IPeriodicHolographicDisplays phd, PluginManager pm, World world) {
        this.phd = phd;
        this.pm = pm;
        this.world = world;
        this.perChunkHandler = new PerChunkHologramHandler();
        new PerChunkListener(phd, pm, world, chunk -> this.chunkLoaded((Chunk)chunk), chunk -> this.chunkUnloaded((Chunk)chunk));
    }

    private void chunkLoaded(Chunk chunk) {
        this.loadedHandlers.addAll(this.perChunkHandler.getHandlersInChunk(chunk.getX(), chunk.getZ()));
    }

    private void chunkUnloaded(Chunk chunk) {
        this.loadedHandlers.removeAll(this.perChunkHandler.getHandlersInChunk(chunk.getX(), chunk.getZ()));
    }

    public IPeriodicHolographicDisplays getPlugin() {
        return this.phd;
    }

    public PluginManager getPluginManager() {
        return this.pm;
    }

    public World getWorld() {
        return this.world;
    }

    protected void addHandler(String name, IndividualHologramHandler handler) {
        this.holograms.put(name, handler);
        Location loc = handler.getHologram().getBukkitLocation();
        int x = loc.getBlockX() >> 4;
        int z = loc.getBlockZ() >> 4;
        this.perChunkHandler.setChunkOf(handler, x, z);
        if (this.world.isChunkLoaded(x, z)) {
            this.loadedHandlers.add(handler);
        }
    }

    protected IndividualHologramHandler getHandler(String name) {
        return this.holograms.get(name);
    }

    protected void removeHandler(String name) {
        IndividualHologramHandler handler = this.holograms.remove(name);
        if (handler != null) {
            this.loadedHandlers.remove(handler);
        }
    }

    protected Collection<IndividualHologramHandler> getHandlers(boolean onlyLoaded) {
        if (onlyLoaded) {
            return new ArrayList<IndividualHologramHandler>(this.loadedHandlers);
        }
        return new ArrayList<IndividualHologramHandler>(this.holograms.values());
    }

    protected Set<Map.Entry<String, IndividualHologramHandler>> getEntries() {
        return new HashSet<Map.Entry<String, IndividualHologramHandler>>(this.holograms.entrySet());
    }

    protected abstract boolean saveHolograms(boolean var1, HologramSaveReason var2);

    public static enum HologramSaveReason {
        ADD,
        PERIODIC,
        MANUAL,
        CHANGE,
        REMOVE;

    }
}

