/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.Settings;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import me.ford.periodicholographicdisplays.holograms.wrap.visibility.VisibilityState;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class PeriodicHologramBase {
    public static final int NO_SECONDS = -1;
    public static final double NO_DISTANCE = -1.0;
    private final IPeriodicHolographicDisplays plugin;
    private final Set<UUID> beingShownTo = new HashSet<UUID>();
    private final String name;
    private double activationDistance;
    private double squareDistance;
    private long showTime;
    private long showTimeTicks;
    private boolean hasChanged = false;
    private final PeriodicType type;
    private final WrappedHologram hologram;
    private String perms;

    public PeriodicHologramBase(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, PeriodicType type, boolean isNew) {
        this(phd, hologram, name, activationDistance, showTime, type, isNew, null);
    }

    public PeriodicHologramBase(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, PeriodicType type, boolean isNew, String perms) {
        Validate.notNull((Object)hologram, (String)"Hologram cannot be null!");
        this.hologram = hologram;
        this.name = name;
        this.plugin = phd;
        if (activationDistance == -1.0) {
            this.defaultDistance(this.plugin.getSettings());
        } else {
            this.setActivationDistance(activationDistance);
        }
        if (showTime == -1L) {
            this.defaultShowtime(this.plugin.getSettings());
        } else {
            this.setShowTime((int)showTime);
        }
        this.type = type;
        this.hasChanged = isNew;
        this.perms = perms;
        hologram.getVisibilitySettings().setGlobalVisibility(VisibilityState.HIDDEN);
    }

    public String getName() {
        return this.name;
    }

    public WrappedHologram getHologram() {
        return this.hologram;
    }

    public void setActivationDistance(double distance) {
        this.setActivationDistance(distance, distance * distance);
        this.hologram.setVisibilityDistance(distance);
    }

    private void setActivationDistance(double distance, double distanceSquared) {
        this.activationDistance = distance;
        this.squareDistance = distanceSquared;
        this.markChanged();
    }

    public double getActivationDistance() {
        return this.activationDistance;
    }

    public double getSquareDistance() {
        return this.squareDistance;
    }

    public void setShowTime(int time) {
        this.setShowTime(time, (long)time * 20L);
    }

    private void setShowTime(int time, long ticks) {
        this.showTime = time;
        this.showTimeTicks = ticks;
        this.markChanged();
    }

    public long getShowTime() {
        return this.showTime;
    }

    public long getShowTimeTicks() {
        return this.showTimeTicks;
    }

    public PeriodicType getType() {
        return this.type;
    }

    public boolean hasPermissions() {
        return this.perms != null;
    }

    public void setPermissions(String perms) {
        this.perms = perms;
        this.markChanged();
    }

    public String getPermissions() {
        return this.perms;
    }

    public void markSaved() {
        this.hasChanged = false;
    }

    public void markRemoved() {
        this.hologram.getVisibilitySettings().clearIndividualVisibilities();
        this.beingShownTo.clear();
    }

    protected void markChanged() {
        this.hasChanged = true;
    }

    public boolean needsSaved() {
        return this.hasChanged;
    }

    public Location getLocation() {
        return this.hologram.getBukkitLocation();
    }

    public abstract void attemptToShow(Player var1);

    protected abstract boolean specialDisable();

    public boolean isBeingShownTo(Player player) {
        return this.beingShownTo.contains(player.getUniqueId());
    }

    public boolean canSee(Player player) {
        return !this.hasPermissions() || player.hasPermission(this.getPermissions());
    }

    public void hideFrom(Player player) {
        if (this.plugin.getSettings().onDebug() && this instanceof FlashingHologram) {
            String info = this.plugin.getMessages().getHologramInfoMessage((FlashingHologram)this, 1, true).getFilled().replace("\n", ";");
            this.plugin.debug(String.format("Hiding from %s: %s", player.getName(), info));
        }
        this.hideFromInternal(player);
        this.beingShownTo.remove(player.getUniqueId());
    }

    protected void hideFromInternal(Player player) {
        this.hologram.getVisibilitySettings().setIndividualVisibility(player, VisibilityState.HIDDEN);
    }

    public boolean show(Player player) {
        boolean scheduleHide;
        if (player == null) {
            return false;
        }
        UUID id = player.getUniqueId();
        if (this.beingShownTo.contains(id)) {
            return false;
        }
        if (this.plugin.getSettings().onDebug() && this instanceof FlashingHologram) {
            String info = this.plugin.getMessages().getHologramInfoMessage((FlashingHologram)this, 1, true).getFilled().replace("\n", ";");
            this.plugin.debug(String.format("Showing to %s: %s", player.getName(), info));
        }
        this.showInternal(player);
        this.beingShownTo.add(id);
        boolean bl = scheduleHide = !this.specialDisable();
        if (scheduleHide) {
            this.plugin.getScheduler().runTaskLater(() -> this.hideFrom(player), this.showTimeTicks);
        }
        return true;
    }

    protected void showInternal(Player player) {
        this.hologram.getVisibilitySettings().setIndividualVisibility(player, VisibilityState.VISIBLE);
    }

    public void defaultDistance(Settings settings) {
        double defDist = settings.getDefaultActivationDistance();
        this.setActivationDistance(-1.0, defDist * defDist);
    }

    public void defaultShowtime(Settings settings) {
        int time = settings.getDefaultShowTime();
        this.setShowTime(-1, (long)time * 20L);
    }

    protected IPeriodicHolographicDisplays getPlugin() {
        return this.plugin;
    }

    public void resetVisibility() {
        for (UUID id : new HashSet<UUID>(this.beingShownTo)) {
            Player player = this.plugin.getPlayer(id);
            if (player == null) continue;
            this.hideFrom(player);
        }
        this.beingShownTo.clear();
    }
}

