/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.events.StartedManagingHologramEvent;
import me.ford.periodicholographicdisplays.holograms.events.StoppedManagingHologramEvent;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import org.apache.commons.lang.Validate;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public class IndividualHologramHandler {
    private final PluginManager pm;
    private final WrappedHologram hologram;
    private final String name;
    private final Map<PeriodicType, FlashingHologram> holograms = new HashMap<PeriodicType, FlashingHologram>();
    private final Map<PeriodicType, FlashingHologram> toSave = new HashMap<PeriodicType, FlashingHologram>();

    public IndividualHologramHandler(PluginManager pm, WrappedHologram hologram, String name) {
        Validate.notNull((Object)hologram, (String)"Periodic hologram cannot be null");
        this.pm = pm;
        this.hologram = hologram;
        this.name = name;
    }

    void addHologram(PeriodicType type, FlashingHologram holo) {
        this.addHologram(type, holo, false);
    }

    void addHologram(PeriodicType type, FlashingHologram holo, boolean wasLoaded) {
        Validate.notNull((Object)((Object)type), (String)"PeriodicType cannot be null");
        Validate.notNull((Object)holo, (String)"Periodic hologram cannot be null");
        Validate.isTrue((holo.getType() == type ? 1 : 0) != 0, (String)("Wrong type of hologram. Expected " + type.name() + " got " + holo.getType().name()));
        Validate.isTrue((boolean)holo.getName().equals(this.name), (String)"Can only handle pHD holograms of the same HD hologram");
        this.pm.callEvent((Event)new StartedManagingHologramEvent(holo));
        this.holograms.put(type, holo);
        if (!wasLoaded) {
            this.toSave.put(type, holo);
        }
    }

    void removeHologram(FlashingHologram hologram, boolean markForRemoval) {
        Validate.notNull((Object)hologram, (String)"Cannot remove null hologram");
        Validate.isTrue((this.hologram == hologram.getHologram() ? 1 : 0) != 0, (String)"Can only add pHD holograms that affect the same HD hologram");
        this.pm.callEvent((Event)new StoppedManagingHologramEvent(hologram));
        this.holograms.remove((Object)hologram.getType());
        hologram.resetVisibility();
        if (this.holograms.isEmpty()) {
            hologram.markRemoved();
        }
        if (markForRemoval) {
            this.toSave.put(hologram.getType(), null);
        }
    }

    public WrappedHologram getHologram() {
        return this.hologram;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.holograms.size() == 0;
    }

    public FlashingHologram getHologram(PeriodicType type) {
        return this.holograms.get((Object)type);
    }

    void setAllNeedingSaved() {
        this.toSave.putAll(this.holograms);
    }

    Map<PeriodicType, FlashingHologram> getToSave() {
        return new HashMap<PeriodicType, FlashingHologram>(this.toSave);
    }

    public Set<FlashingHologram> getHolograms() {
        return new HashSet<FlashingHologram>(this.holograms.values());
    }

    public Set<PeriodicType> getTypes() {
        return new HashSet<PeriodicType>(this.holograms.keySet());
    }

    public boolean hasHolograms() {
        return !this.holograms.isEmpty();
    }

    public boolean needsSaved() {
        for (FlashingHologram holo : this.holograms.values()) {
            if (!holo.needsSaved()) continue;
            this.toSave.put(holo.getType(), holo);
        }
        return !this.toSave.isEmpty();
    }

    public void markSaved() {
        for (FlashingHologram holo : this.holograms.values()) {
            holo.markSaved();
        }
        this.toSave.clear();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        ArrayList<String> types = new ArrayList<String>();
        for (PeriodicType type : this.holograms.keySet()) {
            types.add(type.name());
        }
        return String.format("[IHH:%s;types:%s]", this.name, String.join((CharSequence)", ", types));
    }
}

