/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import dev.ratas.slimedogcore.api.scheduler.SDCTask;
import java.util.Calendar;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class IRLTimeHologram
extends FlashingHologram {
    private static final long DELAY = 1728000L;
    private final IPeriodicHolographicDisplays plugin;
    private final IRLTimeHologramDisplayer displayer;
    private SDCTask task;
    private long atTime;

    public IRLTimeHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, long atTime, boolean isNew, String perms, double flashOn, double flashOff) {
        super(phd, hologram, name, activationDistance, showTime, PeriodicType.IRLTIME, isNew, perms, flashOn, flashOff);
        this.atTime = atTime;
        this.plugin = phd;
        this.displayer = new IRLTimeHologramDisplayer();
        this.initTask();
    }

    private void initTask() {
        Calendar calendar = Calendar.getInstance();
        long curTimeSeconds = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        long curDelay = (this.atTime - curTimeSeconds) * 20L % 1728000L;
        this.plugin.getScheduler().runTaskTimer(task -> this.runDisplayer((SDCTask)task), curDelay, 1728000L);
    }

    private void runDisplayer(SDCTask task) {
        if (this.task == null) {
            this.task = task;
        } else if (this.task != task) {
            task.cancel();
            return;
        }
        this.displayer.run();
    }

    public long getTime() {
        return this.atTime;
    }

    public void setTime(long time) {
        if (this.atTime == time) {
            return;
        }
        this.atTime = time;
        if (this.task != null) {
            this.task.cancel();
        }
        this.initTask();
        this.markChanged();
    }

    @Override
    public void attemptToShow(Player player) {
    }

    private void showInRange() {
        World world = this.getLocation().getWorld();
        double dist = this.getActivationDistance();
        if (dist == -1.0) {
            dist = this.plugin.getSettings().getDefaultActivationDistance();
        }
        for (Entity entity : world.getNearbyEntities(this.getLocation(), dist, dist, dist, e -> e.getType() == EntityType.PLAYER)) {
            Player player = (Player)entity;
            this.show(player);
        }
    }

    @Override
    protected boolean specialDisable() {
        return false;
    }

    private class IRLTimeHologramDisplayer
    implements Runnable {
        private IRLTimeHologramDisplayer() {
        }

        @Override
        public void run() {
            IRLTimeHologram.this.showInRange();
        }
    }
}

