/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.AlwaysHologram;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.IndividualHologramHandler;
import me.ford.periodicholographicdisplays.holograms.MCTimeHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorage;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorageBase;
import me.ford.periodicholographicdisplays.holograms.storage.HologramInfo;
import me.ford.periodicholographicdisplays.holograms.storage.SQLStorage;
import me.ford.periodicholographicdisplays.holograms.storage.Storage;
import me.ford.periodicholographicdisplays.holograms.storage.TypeInfo;
import me.ford.periodicholographicdisplays.holograms.storage.YAMLStorage;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.hooks.NPCHook;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;

public class HologramStorage {
    private Storage storage;
    private final IPeriodicHolographicDisplays plugin;
    private final HologramProvider provider;
    private final PluginManager pm;
    private final NPCHook hook;
    private final Map<World, WorldHologramStorage> holograms = new HashMap<World, WorldHologramStorage>();
    private final Set<Storage.HDHologramInfo> danglingInfos = new HashSet<Storage.HDHologramInfo>();

    public HologramStorage(IPeriodicHolographicDisplays plugin, PluginManager pm) throws InvalidConfigurationException {
        this.storage = plugin.getSettings().useDatabase() ? new SQLStorage(plugin, pm) : new YAMLStorage(plugin, pm);
        this.plugin = plugin;
        this.provider = plugin.getHologramProvider();
        this.pm = pm;
        this.hook = plugin.getNPCHook();
        this.initWorldStorage();
        this.scheduleLoad();
        this.scheduleDanglingCheck();
        this.scheduleSave();
    }

    private void scheduleSave() {
        long seconds = this.plugin.getSettings().getSaveDelay();
        if (seconds < 20L) {
            this.plugin.getLogger().warning(this.plugin.getMessages().getLowSaveDelayMessage().createWith(seconds).getFilled());
        }
        long delay = seconds * 20L;
        this.plugin.getScheduler().runTaskTimer(() -> this.save(WorldHologramStorageBase.HologramSaveReason.PERIODIC, false), delay, delay);
    }

    private void scheduleLoad() {
        this.plugin.getScheduler().runTaskLater(() -> this.storage.loadHolograms(info -> this.loaded((Storage.HDHologramInfo)info, false)), 40L);
    }

    private void scheduleDanglingCheck() {
        this.plugin.getScheduler().runTaskLater(() -> {
            if (!this.danglingInfos.isEmpty()) {
                this.plugin.getLogger().warning("Some pHD holograms were loaded such that they have not found their corresponding hologram:" + this.danglingInfos);
            }
        }, 200L);
    }

    private void loaded(Storage.HDHologramInfo info, boolean imported) {
        this.danglingInfos.add(info);
        WrappedHologram holo = this.provider.getByName(info.getHoloName());
        WorldHologramStorage whs = this.holograms.get(holo.getWorldIfLoaded());
        if (whs == null) {
            this.plugin.getLogger().info("Loaded hologram before world was initialized: " + holo.getName() + " - it should be sorted out once the world loads");
            return;
        }
        this.danglingInfos.remove(info);
        whs.loaded(holo, info, imported);
    }

    public Storage getStorage() {
        return this.storage;
    }

    private void initWorldStorage() {
        for (World world : this.plugin.getWorlds()) {
            this.newWorld(world);
        }
    }

    public void newWorld(World world) {
        this.holograms.put(world, new WorldHologramStorage(this.plugin, this.pm, world, this.storage));
        for (Storage.HDHologramInfo info : this.danglingInfos) {
            this.loaded(info, false);
        }
    }

    public Set<World> getActiveWorlds() {
        return new HashSet<World>(this.holograms.keySet());
    }

    public WorldHologramStorage getHolograms(World world) {
        Validate.notNull((Object)world, (String)"Cannot get holograms of a null world!");
        WorldHologramStorage storage = this.holograms.get(world);
        if (storage == null) {
            storage = new WorldHologramStorage(this.plugin, this.pm, world, this.storage);
            this.holograms.put(world, storage);
        }
        return storage;
    }

    public void reload() throws InvalidConfigurationException {
        this.danglingInfos.clear();
        for (WorldHologramStorage storage : this.holograms.values()) {
            for (FlashingHologram hologram : storage.getHolograms()) {
                storage.removeHologram(hologram, false);
            }
        }
        this.holograms.clear();
        boolean db = this.plugin.getSettings().useDatabase();
        if (this.storage instanceof SQLStorage) {
            ((SQLStorage)this.storage).close();
        }
        this.storage = db ? new SQLStorage(this.plugin, this.pm) : new YAMLStorage(this.plugin, this.pm);
        this.initWorldStorage();
        this.scheduleLoad();
        this.scheduleDanglingCheck();
    }

    public void imported(Storage.HDHologramInfo info) {
        this.loaded(info, true);
    }

    public void addHologram(FlashingHologram hologram) {
        WorldHologramStorage storage = this.getHolograms(hologram.getLocation().getWorld());
        storage.addHologram(hologram);
        storage.saveHolograms(false, WorldHologramStorageBase.HologramSaveReason.ADD);
    }

    public void removeHologram(FlashingHologram hologram) {
        Validate.notNull((Object)hologram, (String)"Cannot remove null hologram");
        WorldHologramStorage storage = this.holograms.get(hologram.getLocation().getWorld());
        storage.removeHologram(hologram);
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean inSync) {
        this.save(WorldHologramStorageBase.HologramSaveReason.MANUAL, inSync);
    }

    public void save(WorldHologramStorageBase.HologramSaveReason reason, boolean inSync) {
        for (WorldHologramStorage storage : this.holograms.values()) {
            storage.saveHolograms(inSync, reason);
        }
        if (inSync && this.storage instanceof SQLStorage) {
            ((SQLStorage)this.storage).close();
        }
    }

    public List<PeriodicType> getAvailableTypes(String name) {
        return this.getAvailableTypes(name, false);
    }

    public List<PeriodicType> getAvailableTypes(String name, boolean includeZombies) {
        for (WorldHologramStorage storage : this.holograms.values()) {
            IndividualHologramHandler handler = storage.getHandler(name);
            if (handler == null) continue;
            ArrayList<PeriodicType> types = new ArrayList<PeriodicType>();
            for (FlashingHologram holo : handler.getHolograms()) {
                types.add(holo.getType());
            }
            return types;
        }
        if (includeZombies) {
            for (Storage.HDHologramInfo info : this.danglingInfos) {
                if (!info.getHoloName().equalsIgnoreCase(name)) continue;
                ArrayList<PeriodicType> types = new ArrayList<PeriodicType>();
                for (HologramInfo i : info.getInfos()) {
                    types.add(i.getType());
                }
                return types;
            }
        }
        return new ArrayList<PeriodicType>();
    }

    public FlashingHologram getHologram(String name, PeriodicType type) {
        for (WorldHologramStorage storage : this.holograms.values()) {
            FlashingHologram holo = storage.getHologram(name, type);
            if (holo == null) continue;
            return holo;
        }
        return null;
    }

    public void mcTimeChanged(World world, long amount) {
        WorldHologramStorage storage = this.holograms.get(world);
        if (storage == null) {
            return;
        }
        for (FlashingHologram holo : storage.getHolograms()) {
            if (holo.getType() != PeriodicType.MCTIME) continue;
            ((MCTimeHologram)holo).timeChanged(amount);
        }
    }

    public void joined(Player player) {
        this.joinedWorld(player, player.getWorld());
    }

    public void joinedWorld(Player player, World world) {
        if (this.hook != null && this.hook.isNPC((Entity)player)) {
            return;
        }
        WorldHologramStorage worldStorage = this.getHolograms(world);
        for (FlashingHologram holo : worldStorage.getHolograms()) {
            AlwaysHologram always;
            if (holo.getType() != PeriodicType.ALWAYS || !(always = (AlwaysHologram)holo).isShownOnWorldJoin()) continue;
            always.attemptToShow(player);
        }
    }

    public void left(Player player) {
        this.leftWorld(player, player.getWorld());
    }

    public void leftWorld(Player player, World world) {
        WorldHologramStorage worldStorage = this.getHolograms(world);
        for (FlashingHologram holo : worldStorage.getHolograms()) {
            AlwaysHologram always;
            if (holo.getType() != PeriodicType.ALWAYS || !(always = (AlwaysHologram)holo).isShownOnWorldJoin()) continue;
            always.hideFrom(player);
        }
    }

    public List<String> getNames(boolean withZombies) {
        List<String> names = this.getNames();
        if (withZombies) {
            for (Storage.HDHologramInfo info : this.danglingInfos) {
                names.add(info.getHoloName());
            }
        }
        return names;
    }

    public List<String> getNames() {
        return this.getNames(null);
    }

    public List<String> getNames(PeriodicType type) {
        ArrayList<String> names = new ArrayList<String>();
        for (WorldHologramStorage storage : this.holograms.values()) {
            for (IndividualHologramHandler holo : storage.getHandlers(false)) {
                if (type != null && holo.getHologram(type) == null) continue;
                names.add(holo.getName());
            }
        }
        return names;
    }

    public boolean hasZombies() {
        return !this.danglingInfos.isEmpty();
    }

    public Set<Storage.HDHologramInfo> getZombies() {
        return new HashSet<Storage.HDHologramInfo>(this.danglingInfos);
    }

    public void checkForZombies() {
        ArrayList<IndividualHologramHandler> toZombie = new ArrayList<IndividualHologramHandler>();
        for (WorldHologramStorage storage : this.holograms.values()) {
            for (IndividualHologramHandler handler : storage.getHandlers(false)) {
                if (!handler.getHologram().isDeleted()) continue;
                this.plugin.debug("The hologram '" + handler.getName() + "' has been detected as being deleted and thus all its pHD handlers will now be zombified");
                toZombie.add(handler);
            }
        }
        for (IndividualHologramHandler handler : toZombie) {
            handler.setAllNeedingSaved();
            WorldHologramStorage storage = this.getHolograms(handler.getHologram().getBukkitLocation().getWorld());
            this.danglingInfos.add(storage.getInfo(handler));
            for (FlashingHologram hologram : handler.getHolograms()) {
                this.removeHologram(hologram);
            }
        }
    }

    public void removeZombie(HologramInfo info) {
        Storage.HDHologramInfo parent = null;
        for (Storage.HDHologramInfo hdInfo : this.danglingInfos) {
            if (!hdInfo.getHoloName().equals(info.getName())) continue;
            parent = hdInfo;
            break;
        }
        if (parent == null) {
            this.plugin.getLogger().log(Level.WARNING, "Attempting to remove zombie but did not find it in the list(1):" + info);
            return;
        }
        if (parent.removeInfo(info)) {
            Storage.HDHologramInfo delInfo = new Storage.HDHologramInfo(info.getName());
            TypeInfo ti = TypeInfo.of(info.getType(), null);
            HologramInfo holoInfo = new HologramInfo(delInfo.getHoloName(), info.getType(), -1.0, -1L, null, ti, -1.0, -1.0);
            delInfo.addInfo(holoInfo);
            HashSet<Storage.HDHologramInfo> set = new HashSet<Storage.HDHologramInfo>();
            set.add(delInfo);
            this.plugin.debug("Removing 'zombie' hologram: " + info);
            this.storage.saveHolograms(set, false);
            if (parent.getInfos().isEmpty()) {
                this.danglingInfos.remove(parent);
            }
        } else {
            this.plugin.getLogger().log(Level.WARNING, "Attempting to remove zombie but did not find it in the list(2):" + info);
        }
    }
}

