/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.holograms;

import me.ford.periodicholographicdisplays.IPeriodicHolographicDisplays;
import me.ford.periodicholographicdisplays.holograms.PeriodicHologramBase;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.WrappedHologram;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class FlashingHologram
extends PeriodicHologramBase {
    public static final double NO_FLASH = -1.0;
    public static final double MIN_FLASH = 1.0;
    private final IPeriodicHolographicDisplays phd;
    private boolean flashes = false;
    private double flashOn = -1.0;
    private double flashOff = -1.0;
    private BukkitTask on = null;
    private BukkitTask off = null;

    public FlashingHologram(IPeriodicHolographicDisplays phd, WrappedHologram hologram, String name, double activationDistance, long showTime, PeriodicType type, boolean isNew, String perms, double flashOn, double flashOff) {
        super(phd, hologram, name, activationDistance, showTime, type, isNew, perms);
        this.phd = phd;
        if (flashOn != -1.0 && flashOff != -1.0) {
            this.setFlashOnOff(flashOn, flashOff, true);
        }
    }

    public boolean flashes() {
        return this.flashes;
    }

    public double getFlashOn() {
        return this.flashOn;
    }

    public double getFlashOff() {
        return this.flashOff;
    }

    public void setFlashOnOff(double flash) {
        this.setFlashOnOff(flash, flash);
    }

    public void setFlashOnOff(double flashOn, double flashOff) {
        this.setFlashOnOff(flashOn, flashOff, false);
    }

    private void setFlashOnOff(double flashOn, double flashOff, boolean onLoad) {
        this.flashes = true;
        this.flashOn = flashOn;
        this.flashOff = flashOff;
        if (!onLoad) {
            this.markChanged();
        }
    }

    public void changeFlashOn(double flashOn) {
        if (!this.flashes) {
            throw new IllegalStateException("Cannot change flash on time when the hologram was previously not flashing");
        }
        this.setFlashOnOff(flashOn, this.flashOff);
    }

    public void changeFlashOff(double flashOff) {
        if (!this.flashes) {
            throw new IllegalStateException("Cannot change flash off time when the hologram was previously not flashing");
        }
        this.setFlashOnOff(this.flashOn, flashOff);
    }

    public void setNoFlash() {
        this.flashes = false;
        this.flashOn = -1.0;
        this.flashOff = -1.0;
        this.markChanged();
    }

    @Override
    public void resetVisibility() {
        super.resetVisibility();
        if (!this.flashes()) {
            return;
        }
        if (this.on == null || this.off == null) {
            return;
        }
        if (this.on.isCancelled() || this.off.isCancelled()) {
            return;
        }
        this.on.cancel();
        this.off.cancel();
    }

    @Override
    public boolean show(Player player) {
        boolean showing = super.show(player);
        if (!this.flashes()) {
            return showing;
        }
        this.phd.debug(String.format("Starting to flash! %3.2f on and %3.2f off", this.flashOn, this.flashOff));
        if (!showing) {
            return false;
        }
        long cycleTicks = (int)((this.flashOn + this.flashOff) * 20.0);
        long offDelay = (int)(this.flashOn * 20.0);
        this.on = new Flasher(player, true).runTaskTimer((Plugin)this.phd.asPlugin(), 0L, cycleTicks);
        this.off = new Flasher(player, false).runTaskTimer((Plugin)this.phd.asPlugin(), offDelay, cycleTicks);
        return true;
    }

    private class Flasher
    extends BukkitRunnable {
        private final Player player;
        private final boolean show;

        public Flasher(Player player, boolean show) {
            this.player = player;
            this.show = show;
        }

        public void run() {
            if (!this.player.isValid() || !this.player.isOnline()) {
                return;
            }
            if (!FlashingHologram.this.isBeingShownTo(this.player) || !FlashingHologram.this.flashes()) {
                this.cancel();
                return;
            }
            if (this.show) {
                FlashingHologram.this.showInternal(this.player);
            } else {
                FlashingHologram.this.hideFromInternal(this.player);
            }
        }
    }
}

