/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.Settings;
import me.ford.periodicholographicdisplays.commands.subcommands.OptionPairSetSub;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.WorldHologramStorageBase;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.hooks.LuckPermsHook;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class SetSub
extends OptionPairSetSub {
    private static final String PERMS = "phd.set";
    private static final String USAGE = "/phd set <hologram> <type> <options...>";
    private final HologramStorage storage;
    private final LuckPermsHook hook;
    private final Messages messages;
    private final List<String> settables = Arrays.asList("times", "time", "seconds", "distance", "permission", "flash", "flashOn", "flashOff");

    public SetSub(HologramProvider provider, HologramStorage storage, LuckPermsHook hook, Settings settings, Messages messages) {
        super(provider, "set", PERMS, USAGE);
        this.storage = storage;
        this.hook = hook;
        this.messages = messages;
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                List<String> names = this.storage.getNames();
                names.sort(String.CASE_INSENSITIVE_ORDER);
                return (List)StringUtil.copyPartialMatches((String)args[0], names, list);
            }
            case 2: {
                ArrayList<String> typeNames = new ArrayList<String>();
                for (PeriodicType type : this.storage.getAvailableTypes(args[0])) {
                    typeNames.add(type.name());
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], typeNames, list);
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                PeriodicType type;
                ArrayList<String> options = new ArrayList<String>(this.settables);
                try {
                    type = PeriodicType.valueOf(args[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return list;
                }
                if (type != PeriodicType.MCTIME && type != PeriodicType.IRLTIME) {
                    options.remove("time");
                }
                if (type != PeriodicType.NTIMES) {
                    options.remove("times");
                }
                for (int i = 2; i < args.length - 2; i += 2) {
                    options.remove(args[i]);
                }
                for (String arg : args) {
                    if (arg.equalsIgnoreCase("flash")) {
                        options.remove("flashOn");
                        options.remove("flashOff");
                        continue;
                    }
                    if (!arg.equalsIgnoreCase("flashOn") && !arg.equalsIgnoreCase("flashOff")) continue;
                    options.remove("flash");
                }
                return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], options, list);
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                if (!args[args.length - 2].equalsIgnoreCase("permission")) break;
                if (this.hook == null) {
                    return list;
                }
                return this.hook.tabCompletePermissions((CommandSender)sender, args[args.length - 1]);
            }
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        Map<String, String> optionPairs;
        PeriodicType type;
        if (args.length < 1) {
            return false;
        }
        String holoName = args[0];
        if (this.storage.getAvailableTypes(holoName).size() == 0) {
            sender.sendMessage(this.messages.getHologramNotManagedMessage().createWith(holoName));
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        try {
            type = PeriodicType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.messages.getTypeNotRecognizedMessage().createWith(args[1]));
            return true;
        }
        if (args.length < 4) {
            return false;
        }
        try {
            optionPairs = this.getOptionPairs(Arrays.copyOfRange(args, 2, args.length));
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.messages.getNeedPairedOptionsMessage().getMessage());
            return true;
        }
        FlashingHologram existing = this.storage.getHologram(holoName, type);
        if (existing == null) {
            sender.sendMessage(this.messages.getHologramNotTrackedMessage().createWith(holoName, type));
            return true;
        }
        try {
            this.setAll(sender, existing, optionPairs, true);
        }
        catch (OptionPairSetSub.OptionPairException e) {
            switch (e.getType()) {
                case NEED_A_NUMBER: {
                    sender.sendMessage(this.messages.getNeedANumberMessage().createWith(e.getExtra()));
                    break;
                }
                case NEED_AN_INTEGER: {
                    sender.sendMessage(this.messages.getNeedAnIntegerMessage().createWith(e.getExtra()));
                    break;
                }
                case INCORRECT_TIME: {
                    sender.sendMessage(this.messages.getIncorrectTimeMessage().createWith(e.getExtra()));
                    break;
                }
                case NO_SUCH_OPTION: {
                    sender.sendMessage(this.messages.getNoSuchOptionMessage().createWith(type, e.getExtra()));
                    break;
                }
                case DISTANCE_NEGATIVE: {
                    sender.sendMessage(this.messages.getDistanceTooSmallMessage().createWith(e.getExtra()));
                    break;
                }
                case SECONDS_NEGATIVE: {
                    sender.sendMessage(this.messages.getSecondsTooSmallMessage().createWith(e.getExtra()));
                    break;
                }
                case FLASH_ONLY_ONE: {
                    sender.sendMessage(this.messages.getFlashMustHaveBothMessage().createWith(e.getExtra()));
                    break;
                }
                case FLASH_TOO_SMALL: {
                    sender.sendMessage(this.messages.getFlashTimeTooSmallMessage().createWith(e.getExtra()));
                    break;
                }
                case TIMES_TOO_SMALL: {
                    sender.sendMessage(this.messages.getNegativeTimesMessage().createWith(e.getExtra()));
                    break;
                }
                default: {
                    sender.sendRawMessage("Unusual problem: " + e);
                }
            }
            return true;
        }
        existing.resetVisibility();
        this.storage.save(WorldHologramStorageBase.HologramSaveReason.CHANGE, false);
        sender.sendMessage(this.messages.getSetNewOptionsMessage().createWith(holoName, type, optionPairs));
        return true;
    }
}

