/*
 * Decompiled with CFR 0.152.
 */
package me.ford.periodicholographicdisplays.commands.subcommands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import me.ford.periodicholographicdisplays.Messages;
import me.ford.periodicholographicdisplays.commands.PHDSubCommand;
import me.ford.periodicholographicdisplays.holograms.FlashingHologram;
import me.ford.periodicholographicdisplays.holograms.HologramStorage;
import me.ford.periodicholographicdisplays.holograms.NTimesHologram;
import me.ford.periodicholographicdisplays.holograms.PeriodicType;
import me.ford.periodicholographicdisplays.holograms.wrap.provider.HologramProvider;
import me.ford.periodicholographicdisplays.users.UserCache;
import me.ford.periodicholographicdisplays.util.HintUtil;
import me.ford.periodicholographicdisplays.util.PageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ReportSub
extends PHDSubCommand {
    private static final String PERMS = "phd.report";
    private static final String USAGE = "/phd report NTIMES <player> [page]";
    private final HologramStorage storage;
    private final Messages messages;
    private final UserCache userCache;

    public ReportSub(HologramProvider provider, HologramStorage storage, Messages messages, UserCache userCache) {
        super(provider, "report", PERMS, USAGE);
        this.storage = storage;
        this.messages = messages;
        this.userCache = userCache;
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                list.add(PeriodicType.NTIMES.name());
                return list;
            }
            case 2: {
                if (args[1].length() < 2) {
                    return null;
                }
                return this.userCache.getNamesStartingWith(args[1]);
            }
        }
        return list;
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet options) {
        PeriodicType type;
        if (args.length < 2) {
            return false;
        }
        try {
            type = PeriodicType.valueOf(args[0].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (type != PeriodicType.NTIMES) {
            return false;
        }
        Player player = Bukkit.getPlayer((String)args[1]);
        if (player == null) {
            UUID id = this.userCache.getUuid(args[1]);
            if (id != null) {
                player = Bukkit.getOfflinePlayer((UUID)id);
            }
            if (player == null || !player.hasPlayedBefore()) {
                sender.sendMessage(this.messages.getPlayerNotFoundMessage().createWith(args[1]));
                return true;
            }
        }
        int page = 1;
        if (args.length > 2) {
            try {
                page = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.messages.getNeedAnIntegerMessage().createWith(args[2]));
                return true;
            }
        }
        ArrayList<NTimesHologram> holograms = new ArrayList<NTimesHologram>();
        for (World world : this.storage.getActiveWorlds()) {
            for (FlashingHologram holo : this.storage.getHolograms(world).getHolograms()) {
                if (holo.getType() != type) continue;
                holograms.add((NTimesHologram)holo);
            }
        }
        holograms.sort(new Comparator<NTimesHologram>(){

            @Override
            public int compare(NTimesHologram o1, NTimesHologram o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
        int maxPage = PageUtils.getNumberOfPages(holograms.size(), 8);
        if (maxPage == 0) {
            ++maxPage;
        }
        if (page < 1 || page > maxPage) {
            sender.sendMessage(this.messages.getInvalidPageMessage().createWith(maxPage));
            return true;
        }
        sender.sendMessage(this.messages.getNtimesReportMessage((OfflinePlayer)player, holograms, page, sender instanceof Player));
        if (page < maxPage && sender instanceof Player) {
            HintUtil.sendHint(sender, this.messages.getNextPageHint().createWith("{command}").getFilled(), "{command}", String.format("/phd report NTIMES %s %d", player.getName(), page + 1));
        }
        return true;
    }
}

