/*
 * Decompiled with CFR 0.152.
 */
package dev.ratas.slimedogcore.impl.messaging.recipient;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import dev.ratas.slimedogcore.api.messaging.SDCMessage;
import dev.ratas.slimedogcore.api.messaging.context.SDCContext;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import dev.ratas.slimedogcore.impl.SlimeDogCore;
import dev.ratas.slimedogcore.impl.messaging.mini.MiniMessageUtil;
import dev.ratas.slimedogcore.shade.kyori.adventure.audience.Audience;
import dev.ratas.slimedogcore.shade.kyori.adventure.platform.bukkit.BukkitAudiences;
import dev.ratas.slimedogcore.shade.kyori.adventure.text.Component;
import dev.ratas.slimedogcore.shade.kyori.adventure.text.minimessage.MiniMessage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageRecipient
implements SDCRecipient {
    private static final LazyAudiences AUDIENCES = new LazyAudiences();
    protected final CommandSender delegate;
    private final boolean allowMiniMessages;

    public MessageRecipient(CommandSender delegate) {
        this(delegate, true);
    }

    public MessageRecipient(CommandSender delegate, boolean allowMiniMessages) {
        this.delegate = delegate;
        this.allowMiniMessages = allowMiniMessages;
    }

    @Override
    public <T extends SDCContext> void sendMessage(SDCMessage<T> message) {
        String msg = message.getFilled();
        boolean isJson = MessageRecipient.isJson(msg);
        if (!isJson) {
            msg = this.color(msg);
        }
        this.sendTo(message.getTarget().getSpigotType(), msg, isJson);
    }

    protected void sendTo(ChatMessageType target, String msg, boolean parseJson) {
        if (this.allowMiniMessages && MiniMessageUtil.textCouldBeMiniMessage(msg)) {
            this.sendMiniMessage(target, msg);
            return;
        }
        BaseComponent[] comps = !parseJson ? TextComponent.fromLegacyText((String)msg) : ComponentSerializer.parse((String)msg);
        if (this.delegate instanceof Player) {
            ((Player)this.delegate).spigot().sendMessage(target, comps);
        } else {
            this.delegate.spigot().sendMessage(comps);
        }
    }

    protected void sendMiniMessage(ChatMessageType target, String msg) {
        MiniMessage mm = MiniMessage.miniMessage();
        Object comp = mm.deserialize(msg);
        Audience audience = AUDIENCES.get().sender(this.delegate);
        if (target == ChatMessageType.CHAT) {
            audience.sendMessage((Component)comp);
        } else if (target == ChatMessageType.ACTION_BAR) {
            audience.sendActionBar((Component)comp);
        } else {
            throw new IllegalStateException("Unimplemented message target: " + target);
        }
    }

    @Override
    public boolean hasPermission(String perms) {
        return this.delegate.hasPermission(perms);
    }

    protected String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    @Override
    public void sendRawMessage(String msg) {
        this.sendTo(ChatMessageType.CHAT, msg, false);
    }

    public static boolean isJson(String json) {
        return MessageRecipient.isJson(new StringReader(json));
    }

    private static boolean isJson(Reader reader) {
        return MessageRecipient.isJson(new JsonReader(reader));
    }

    private static boolean isJson(JsonReader jsonReader) {
        try {
            JsonToken token;
            block11: while ((token = jsonReader.peek()) != JsonToken.END_DOCUMENT && token != null) {
                switch (token) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        continue block11;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        continue block11;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        continue block11;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        continue block11;
                    }
                    case NAME: {
                        jsonReader.nextName();
                        continue block11;
                    }
                    case STRING: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case NULL: {
                        jsonReader.skipValue();
                        continue block11;
                    }
                    case END_DOCUMENT: {
                        break block11;
                    }
                    default: {
                        throw new AssertionError(token);
                    }
                }
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    private static final class LazyAudiences {
        private BukkitAudiences audiences = null;

        private LazyAudiences() {
        }

        private BukkitAudiences get() {
            if (this.audiences == null) {
                this.audiences = LazyAudiences.initAudiences();
            }
            return this.audiences;
        }

        private static BukkitAudiences initAudiences() {
            return ((SlimeDogCore)JavaPlugin.getProvidingPlugin(MessageRecipient.class)).getAudiences();
        }
    }
}

