/*
 * Decompiled with CFR 0.152.
 */
package dev.ratas.slimedogcore.impl.commands;

import dev.ratas.slimedogcore.api.commands.SDCCommandOptionSet;
import dev.ratas.slimedogcore.api.commands.SDCParentCommand;
import dev.ratas.slimedogcore.api.commands.SDCSubCommand;
import dev.ratas.slimedogcore.api.messaging.recipient.SDCRecipient;
import dev.ratas.slimedogcore.impl.utils.StringIgnoreCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.util.StringUtil;

public abstract class AbstractParentCommand
implements SDCParentCommand {
    private final Map<StringIgnoreCase, SDCSubCommand> subCommands = new HashMap<StringIgnoreCase, SDCSubCommand>();

    @Override
    public SDCSubCommand getSubCommand(String name) {
        return this.subCommands.get(new StringIgnoreCase(name));
    }

    @Override
    public void addSubCommand(SDCSubCommand subCommand) {
        this.subCommands.put(new StringIgnoreCase(subCommand.getName()), subCommand);
    }

    @Override
    public List<String> onTabComplete(SDCRecipient sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], this.getApplicableSubCommandNames(sender), new ArrayList());
        }
        SDCSubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand == null || !subCommand.hasPermission(sender)) {
            return Collections.emptyList();
        }
        return subCommand.onTabComplete(sender, this.removeFirstArg(args));
    }

    @Override
    public boolean onOptionedCommand(SDCRecipient sender, String[] args, SDCCommandOptionSet opts) {
        if (args.length == 0) {
            sender.sendRawMessage(this.getUsage(sender));
            return true;
        }
        SDCSubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand == null || !subCommand.hasPermission(sender)) {
            return false;
        }
        if (!subCommand.onOptionedCommand(sender, this.removeFirstArg(args), opts)) {
            sender.sendRawMessage(subCommand.getUsage(sender, args));
        }
        return true;
    }

    @Override
    public String getUsage(SDCRecipient recipient) {
        ArrayList<String> usages = new ArrayList<String>();
        String[] args = new String[]{};
        for (String subName : this.getApplicableSubCommandNames(recipient)) {
            SDCSubCommand sc = this.getSubCommand(subName);
            usages.add(sc.getUsage(recipient, args));
        }
        return String.join((CharSequence)"\n", usages);
    }

    protected String[] removeFirstArg(String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    protected List<String> getApplicableSubCommandNames(SDCRecipient sender) {
        ArrayList<String> names = new ArrayList<String>();
        for (SDCSubCommand subCommand : this.subCommands.values()) {
            if (!subCommand.hasPermission(sender) || !subCommand.showOnTabComplete()) continue;
            names.add(subCommand.getName());
        }
        return names;
    }
}

