/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.message;

import com.google.common.collect.Lists;
import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.Language;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Messages
implements ReloadAble {
    private static final Map<Plugin, Map<Language, Messages>> MESSAGESS = new HashMap<Plugin, Map<Language, Messages>>();
    private YamlConfiguration yaml;
    private final Language language;
    private final Plugin plugin;

    public static Messages getMessages(Plugin plugin) {
        return Messages.getMessages(plugin, Language.getDefaultLanguage());
    }

    public static Messages getMessages(Plugin plugin, Language language) {
        Map map = MESSAGESS.computeIfAbsent(plugin, plugin1 -> new HashMap());
        return map.computeIfAbsent(language, language1 -> new Messages(plugin, language));
    }

    public static void unLoadMessages(Plugin plugin, Language language) {
        Map<Language, Messages> map = MESSAGESS.get(plugin);
        if (map == null) {
            return;
        }
        Messages messages = map.get((Object)language);
        if (messages == null) {
            return;
        }
        RELOAD_ABLES.remove(messages);
        MESSAGESS.remove(messages);
    }

    private Messages(Plugin plugin, Language language) {
        this.language = language;
        this.plugin = plugin;
        this.reload();
        RELOAD_ABLES.add(this);
    }

    void sendMessage(MessageKey key, CommandSender target, MessageValue ... messageValues) {
        List<String> stringList = this.getRawStringList(key);
        stringList.forEach(value -> target.sendMessage(MessageUtil.replacePlaceHolder(this.plugin, value, messageValues)));
    }

    void broadcastMessage(MessageKey key, MessageValue ... messageValues) {
        List<String> stringList = this.getRawStringList(key);
        stringList.forEach(value -> Bukkit.broadcastMessage((String)MessageUtil.replacePlaceHolder(this.plugin, value, messageValues)));
    }

    void broadcastMessage(MessageKey key, String permission, MessageValue ... messageValues) {
        List<String> stringList = this.getRawStringList(key);
        stringList.forEach(value -> Bukkit.broadcast((String)MessageUtil.replacePlaceHolder(this.plugin, value, messageValues), (String)permission));
    }

    String getRawMessages(MessageKey key) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getRawStringList(key);
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    List<String> getRawStringList(MessageKey key) {
        List stringList = this.yaml.isList(key.getKey()) ? this.yaml.getStringList(key.getKey()) : (!this.yaml.isString(key.getKey()) ? Lists.newArrayList((Object[])new String[]{"String: " + key.getKey() + " not found!"}) : Lists.newArrayList((Object[])new String[]{this.yaml.getString(key.getKey())}));
        return stringList;
    }

    String getMessage(MessageKey key, MessageValue ... messageValues) {
        return MessageUtil.replacePlaceHolder(this.plugin, this.getRawMessages(key), messageValues);
    }

    List<String> getStringList(MessageKey key, MessageValue ... messageValues) {
        List<String> stringList = this.getRawStringList(key);
        ArrayList<String> newList = new ArrayList<String>();
        stringList.stream().map(string -> MessageUtil.replacePlaceHolder(this.plugin, string, messageValues)).forEach(newList::add);
        return newList;
    }

    @Override
    public void reload() {
        this.yaml = Config.getConfig(this.plugin, this.language.getFileLocation());
    }
}

