/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.message;

import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MessageUtil {
    private static final int DEFAULT_LORE_LENGTH = 40;
    private static final int MINIMUM_LORE_LENGTH = 15;

    public static String replacePlaceHolder(Plugin plugin, String string, MessageValue ... messageValues) {
        string = MessageUtil.replaceTranslation(plugin, string, messageValues);
        for (MessageValue value : messageValues) {
            string = string.replace("%" + value.getKey() + "%", value.getValue());
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public static List<String> replaceList(Plugin plugin, List<String> strings, MessageValue ... messageValues) {
        LinkedList<String> list = new LinkedList<String>();
        strings.stream().map(line -> MessageUtil.replacePlaceHolder(plugin, line, messageValues)).flatMap(line -> {
            if (line.contains("\n") || line.contains("%%new-line%")) {
                return Stream.of(line.split("(\\n|%%new-line%)"));
            }
            return Stream.of(line);
        }).forEach(list::add);
        return list;
    }

    public static ItemStack replaceItemStack(Plugin plugin, ItemStack itemStack, MessageValue ... messageValues) {
        if (!itemStack.hasItemMeta()) {
            return itemStack;
        }
        itemStack.setItemMeta(MessageUtil.replaceItemMeta(plugin, itemStack.getItemMeta(), messageValues));
        return itemStack;
    }

    public static ItemMeta replaceItemMeta(Plugin plugin, ItemMeta itemMeta, MessageValue ... messageValues) {
        if (itemMeta.hasDisplayName()) {
            itemMeta.setDisplayName(MessageUtil.replacePlaceHolder(plugin, itemMeta.getDisplayName(), messageValues));
        }
        if (itemMeta.hasLore()) {
            LinkedList lore = new LinkedList();
            MessageUtil.replaceList(plugin, itemMeta.getLore(), messageValues).forEach(string -> lore.addAll(MessageUtil.splitString(string, itemMeta.hasDisplayName() ? (itemMeta.getDisplayName().length() < 15 ? 40 : itemMeta.getDisplayName().length()) : 40)));
            itemMeta.setLore(lore);
        }
        return itemMeta;
    }

    public static List<String> splitString(String msg, int lineSize) {
        LinkedList<String> strings = new LinkedList<String>();
        if (!msg.contains("%%split%")) {
            strings.add(msg);
            return strings;
        }
        Pattern pattern = Pattern.compile("\\b.{1," + (lineSize - 1) + "}\\b\\W?");
        Matcher matcher = pattern.matcher(msg.replace("%%split%", ""));
        while (matcher.find()) {
            strings.add(matcher.group());
        }
        return strings;
    }

    public static String replaceTranslation(Plugin plugin, String string, MessageValue ... messageValues) {
        if (!string.contains("%%translation:[")) {
            return string;
        }
        Pattern pattern = Pattern.compile("%%translation:(.*?)]%");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string);
        while (matcher.find()) {
            String key = stringBuilder.substring(matcher.start() + 15, matcher.end() - 2);
            key = MessageUtil.replacePlaceHolder(plugin, key, messageValues);
            stringBuilder.replace(matcher.start(), matcher.end(), new MessageKey(plugin, key).getRawMessage());
            matcher = pattern.matcher(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }
}

