/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.gui.BasicGui;
import de.derfrzocker.custom.ore.generator.utils.gui.BasicSettings;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VerifyGui
extends BasicGui {
    public VerifyGui(Plugin plugin, Consumer<InventoryClickEvent> acceptAction, Consumer<InventoryClickEvent> denyAction) {
        this(plugin, acceptAction, denyAction, VerifyGuiSettings.getInstance(plugin));
    }

    public VerifyGui(Plugin plugin, Consumer<InventoryClickEvent> acceptAction, Consumer<InventoryClickEvent> denyAction, MessageValue ... messageValues) {
        this(plugin, acceptAction, denyAction, VerifyGuiSettings.getInstance(plugin), messageValues);
    }

    public <T extends BasicSettings> VerifyGui(Plugin plugin, Consumer<InventoryClickEvent> acceptAction, Consumer<InventoryClickEvent> denyAction, T setting) {
        super(plugin, setting);
        this.addItem(((VerifyGuiSettingsInterface)((Object)setting)).getAcceptSlot(), MessageUtil.replaceItemStack(plugin, ((VerifyGuiSettingsInterface)((Object)setting)).getAcceptItemStack(), new MessageValue[0]), acceptAction);
        this.addItem(((VerifyGuiSettingsInterface)((Object)setting)).getDenySlot(), MessageUtil.replaceItemStack(plugin, ((VerifyGuiSettingsInterface)((Object)setting)).getDenyItemStack(), new MessageValue[0]), denyAction);
    }

    public <T extends BasicSettings> VerifyGui(Plugin plugin, Consumer<InventoryClickEvent> acceptAction, Consumer<InventoryClickEvent> denyAction, T setting, MessageValue ... messageValues) {
        super(plugin, setting);
        this.addItem(((VerifyGuiSettingsInterface)((Object)setting)).getAcceptSlot(), MessageUtil.replaceItemStack(plugin, ((VerifyGuiSettingsInterface)((Object)setting)).getAcceptItemStack(), messageValues), acceptAction);
        this.addItem(((VerifyGuiSettingsInterface)((Object)setting)).getDenySlot(), MessageUtil.replaceItemStack(plugin, ((VerifyGuiSettingsInterface)((Object)setting)).getDenyItemStack(), messageValues), denyAction);
    }

    public static final class VerifyGuiSettings
    extends BasicSettings
    implements VerifyGuiSettingsInterface {
        private static final Map<Plugin, VerifyGuiSettings> VERIFY_GUI_SETTINGS_MAP = new HashMap<Plugin, VerifyGuiSettings>();

        private VerifyGuiSettings(Plugin plugin) {
            super(plugin, "data/gui/verify-gui.yml");
        }

        public static VerifyGuiSettings getInstance(Plugin plugin) {
            return VERIFY_GUI_SETTINGS_MAP.computeIfAbsent(plugin, VerifyGuiSettings::new);
        }

        @Override
        public int getAcceptSlot() {
            return this.getSection().getInt("accept.slot");
        }

        @Override
        public ItemStack getAcceptItemStack() {
            return this.getSection().getItemStack("accept.item-stack").clone();
        }

        @Override
        public ItemStack getDenyItemStack() {
            return this.getSection().getItemStack("deny.item-stack").clone();
        }

        @Override
        public int getDenySlot() {
            return this.getSection().getInt("deny.slot");
        }
    }

    public static interface VerifyGuiSettingsInterface {
        public int getAcceptSlot();

        public ItemStack getAcceptItemStack();

        public ItemStack getDenyItemStack();

        public int getDenySlot();
    }
}

