/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.gui.InventoryGui;
import de.derfrzocker.custom.ore.generator.utils.gui.InventoryGuiManager;
import de.derfrzocker.custom.ore.generator.utils.gui.InventoryUtil;
import de.derfrzocker.custom.ore.generator.utils.gui.PageSettings;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class PageGui<T>
extends InventoryGui {
    private final Map<Integer, SubPageGui> guis = new HashMap<Integer, SubPageGui>();
    private final Map<Integer, Consumer<InventoryClickEvent>> button = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    private final PageSettings pageSettings;
    private BiConsumer<T, InventoryClickEvent> eventBiConsumer;
    private Function<T, ItemStack> itemStackFunction;
    private int pages;
    private int nextPage;
    private int previousPage;
    private boolean init = false;
    private boolean addDecorations = false;
    private MessageValue[] decorationMessageValues;

    public PageGui(@NotNull Plugin plugin, @NotNull PageSettings pageSettings) {
        super(plugin);
        Validate.notNull((Object)pageSettings, (String)"PageSettings can not be null");
        this.pageSettings = pageSettings;
    }

    public void init(@NotNull T[] values, @NotNull IntFunction<T[]> function, @NotNull Function<T, ItemStack> itemStackFunction, @NotNull BiConsumer<T, InventoryClickEvent> eventBiConsumer) {
        if (this.init) {
            return;
        }
        this.init = true;
        Validate.notNull(values, (String)"Values can not be null");
        Validate.notNull(function, (String)"IntFunction can not be null");
        Validate.notNull(itemStackFunction, (String)"Function for ItemStack can not be null");
        Validate.notNull(eventBiConsumer, (String)"BiConsumer can not be null");
        this.eventBiConsumer = eventBiConsumer;
        this.itemStackFunction = itemStackFunction;
        this.nextPage = this.pageSettings.getNextPageSlot();
        this.previousPage = this.pageSettings.getPreviousPageSlot();
        int slots = InventoryUtil.calculateSlots(this.pageSettings.getRows() - this.pageSettings.getEmptyRowsBelow() - this.pageSettings.getEmptyRowsUp(), this.pageSettings.getGap());
        this.pages = InventoryUtil.calculatePages(slots, values.length);
        for (int i = 0; i < this.pages; ++i) {
            T[] subValues = i == this.pages - 1 ? function.apply(values.length - i * slots) : function.apply(slots);
            System.arraycopy(values, i * slots, subValues, 0, subValues.length);
            this.guis.put(i, new SubPageGui(subValues, i));
        }
    }

    public void addItem(int slot, @NotNull ItemStack itemStack, @NotNull Consumer<InventoryClickEvent> consumer) {
        this.button.put(slot, consumer);
        this.guis.forEach((key, value) -> value.getInventory().setItem(slot, itemStack));
    }

    public void addItem(int slot, @NotNull ItemStack itemStack) {
        this.guis.forEach((key, value) -> value.getInventory().setItem(slot, itemStack));
    }

    public boolean updateItemStack(@NotNull T value, @NotNull ItemStack itemStack) {
        boolean update = false;
        for (SubPageGui subPageGui : this.guis.values()) {
            if (!subPageGui.updateItemStack(value, itemStack)) continue;
            update = true;
        }
        return update;
    }

    public void addDecorations(MessageValue ... messageValues) {
        this.addDecorations = true;
        this.decorationMessageValues = messageValues;
        this.pageSettings.getDecorations().forEach(pair -> {
            ItemStack itemStack = MessageUtil.replaceItemStack(this.getPlugin(), (ItemStack)pair.getSecond(), messageValues);
            ((Set)pair.getFirst()).forEach(integer -> this.addItem((int)integer, itemStack));
        });
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    Inventory getInventory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void openSync(@NotNull HumanEntity entity) {
        Validate.notNull((Object)entity, (String)"Entity can not be null");
        SubPageGui subPageGui = this.guis.get(0);
        if (Bukkit.isPrimaryThread()) {
            InventoryGuiManager.getInventoryGuiManager(this.getPlugin()).registerInventoryGui(subPageGui);
            entity.openInventory(subPageGui.getInventory());
            return;
        }
        try {
            Bukkit.getScheduler().callSyncMethod(this.getPlugin(), () -> {
                InventoryGuiManager.getInventoryGuiManager(this.getPlugin()).registerInventoryGui(subPageGui);
                return entity.openInventory(subPageGui.getInventory());
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error while open inventory Sync!", e);
        }
    }

    private final class SubPageGui
    extends InventoryGui {
        @NotNull
        private final Inventory inventory;
        private final int page;
        private final Map<Integer, T> values;

        private SubPageGui(T[] values, int page) {
            super(PageGui.super.getPlugin());
            this.values = new HashMap();
            this.page = page;
            MessageValue[] messageValues = new MessageValue[]{new MessageValue("page", String.valueOf(page)), new MessageValue("pages", String.valueOf(PageGui.this.pages))};
            this.inventory = Bukkit.createInventory(null, (int)(PageGui.this.pageSettings.getRows() * 9), (String)MessageUtil.replacePlaceHolder(this.getPlugin(), PageGui.this.pageSettings.getInventoryName(), messageValues));
            if (PageGui.this.addDecorations) {
                PageGui.this.pageSettings.getDecorations().forEach(pair -> {
                    ItemStack itemStack = MessageUtil.replaceItemStack(this.getPlugin(), (ItemStack)pair.getSecond(), PageGui.this.decorationMessageValues);
                    ((Set)pair.getFirst()).forEach(slot -> this.getInventory().setItem(slot.intValue(), itemStack));
                });
            }
            if (page + 1 != PageGui.this.pages) {
                this.inventory.setItem(PageGui.this.nextPage, MessageUtil.replaceItemStack(this.getPlugin(), PageGui.this.pageSettings.getNextPageItemStack(), messageValues));
            }
            if (page != 0) {
                this.inventory.setItem(PageGui.this.previousPage, MessageUtil.replaceItemStack(this.getPlugin(), PageGui.this.pageSettings.getPreviousPageItemStack(), messageValues));
            }
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                int slot = InventoryUtil.calculateSlot(i, PageGui.this.pageSettings.getGap()) + PageGui.this.pageSettings.getEmptyRowsUp() * 9;
                this.inventory.setItem(slot, PageGui.this.itemStackFunction.apply(value));
                this.values.put(slot, value);
            }
        }

        public boolean updateItemStack(@NotNull T value, @NotNull ItemStack itemStack) {
            boolean update = false;
            for (Map.Entry entry : this.values.entrySet()) {
                if (!entry.getValue().equals(value)) continue;
                this.inventory.setItem(entry.getKey().intValue(), itemStack);
                update = true;
            }
            return update;
        }

        @Override
        @NotNull
        Inventory getInventory() {
            return this.inventory;
        }

        @Override
        public void onClick(@NotNull InventoryClickEvent event) {
            if (event.getRawSlot() == PageGui.this.previousPage && this.page != 0) {
                PageGui.this.guis.get(this.page - 1).openSync(event.getWhoClicked());
                return;
            }
            if (event.getRawSlot() == PageGui.this.nextPage && this.page + 1 != PageGui.this.pages) {
                PageGui.this.guis.get(this.page + 1).openSync(event.getWhoClicked());
                return;
            }
            Consumer<InventoryClickEvent> consumer = PageGui.this.button.get(event.getRawSlot());
            if (consumer != null) {
                consumer.accept(event);
                return;
            }
            Object value = this.values.get(event.getRawSlot());
            if (value == null) {
                return;
            }
            PageGui.this.eventBiConsumer.accept(value, event);
        }
    }
}

