/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.gui.InventoryGui;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InventoryGuiManager
implements Listener {
    private static final Set<HumanEntity> HUMAN_ENTITY_SET = Collections.synchronizedSet(new HashSet());
    private static final Map<Plugin, InventoryGuiManager> INVENTORY_GUI_MANAGER_MAP = new HashMap<Plugin, InventoryGuiManager>();
    private final Map<Inventory, InventoryGui> inventoryGuiMap = new HashMap<Inventory, InventoryGui>();
    @NotNull
    private final Plugin plugin;

    private InventoryGuiManager(@NotNull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public static InventoryGuiManager getInventoryGuiManager(@NotNull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        return INVENTORY_GUI_MANAGER_MAP.computeIfAbsent(plugin, InventoryGuiManager::new);
    }

    public void registerInventoryGui(@NotNull InventoryGui inventoryGui) {
        Validate.notNull((Object)inventoryGui, (String)"InventoryGui can not be null");
        if (!inventoryGui.getPlugin().equals(this.plugin)) {
            throw new IllegalArgumentException("The InventoryGui is not from the same plugin(" + inventoryGui.getPlugin() + ") as the InventoryGuiManager(" + this.plugin + ")");
        }
        this.inventoryGuiMap.put(inventoryGui.getInventory(), inventoryGui);
    }

    @EventHandler
    public void onInventoryClick(@NotNull InventoryClickEvent event) {
        InventoryGui inventoryGui = this.inventoryGuiMap.get(event.getView().getTopInventory());
        if (inventoryGui == null) {
            return;
        }
        event.setCancelled(true);
        if (HUMAN_ENTITY_SET.contains(event.getWhoClicked())) {
            return;
        }
        HUMAN_ENTITY_SET.add(event.getWhoClicked());
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                inventoryGui.onClick(event);
            }
            catch (Exception e) {
                event.getWhoClicked().sendMessage("\u00a74Error while execute gui action, see console for more information.");
                event.getWhoClicked().sendMessage("\u00a74Please report the error to the Developer.");
                e.printStackTrace();
            }
            finally {
                HUMAN_ENTITY_SET.remove(event.getWhoClicked());
            }
        });
    }

    @EventHandler
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        InventoryGui inventoryGui = this.inventoryGuiMap.get(event.getView().getTopInventory());
        if (inventoryGui == null) {
            return;
        }
        if (inventoryGui.getInventory().getViewers().size() > 1) {
            return;
        }
        this.inventoryGuiMap.remove(inventoryGui.getInventory());
    }
}

