/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.gui.InventoryGuiManager;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryGui {
    @NotNull
    private final Plugin plugin;

    public InventoryGui(@NotNull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        this.plugin = plugin;
    }

    @NotNull
    abstract Inventory getInventory();

    public abstract void onClick(@NotNull InventoryClickEvent var1);

    public void openSync(@NotNull HumanEntity entity) {
        Validate.notNull((Object)entity, (String)"Entity can not be null");
        if (Bukkit.isPrimaryThread()) {
            InventoryGuiManager.getInventoryGuiManager(this.getPlugin()).registerInventoryGui(this);
            entity.openInventory(this.getInventory());
            return;
        }
        try {
            Bukkit.getScheduler().callSyncMethod(this.getPlugin(), () -> {
                InventoryGuiManager.getInventoryGuiManager(this.getPlugin()).registerInventoryGui(this);
                return entity.openInventory(this.getInventory());
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error while open inventory Sync!", e);
        }
    }

    public void closeSync(@NotNull HumanEntity entity) {
        Validate.notNull((Object)entity, (String)"Entity can not be null");
        if (Bukkit.isPrimaryThread()) {
            entity.closeInventory();
            return;
        }
        try {
            Bukkit.getScheduler().callSyncMethod(this.getPlugin(), () -> {
                entity.closeInventory();
                return true;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error while close inventory Sync!", e);
        }
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

