/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.Pair;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public class BasicSettings
implements ReloadAble {
    @NotNull
    private final Set<Supplier<ConfigurationSection>> others = new LinkedHashSet<Supplier<ConfigurationSection>>();
    @NotNull
    private final Supplier<ConfigurationSection> configurationSectionSupplier;
    @NotNull
    private final Plugin plugin;
    @NotNull
    private ConfigurationSection section;

    public BasicSettings(@NotNull Plugin plugin, @NotNull String file) {
        this(plugin, file, true);
    }

    public BasicSettings(@NotNull Plugin plugin, @NotNull String file, boolean copy) {
        this(plugin, () -> copy ? Config.getConfig(plugin, file, false) : new Config(plugin.getResource(file)));
    }

    public BasicSettings(@NotNull Plugin plugin, @NotNull Supplier<ConfigurationSection> configurationSectionSupplier) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        Validate.notNull(configurationSectionSupplier, (String)"Supplier can not be null");
        this.configurationSectionSupplier = configurationSectionSupplier;
        this.plugin = plugin;
        this.section = configurationSectionSupplier.get();
        RELOAD_ABLES.add(this);
        this.reload();
    }

    public void addValues(@NotNull String file) {
        this.addValues(file, true);
    }

    public void addValues(@NotNull String file, boolean copy) {
        this.addValues(() -> copy ? Config.getConfig(this.plugin, file, false) : new Config(this.plugin.getResource(file)));
    }

    public void addValues(@NotNull Supplier<ConfigurationSection> configurationSectionSupplier) {
        Validate.notNull(configurationSectionSupplier, (String)"Supplier can not be null");
        this.others.add(configurationSectionSupplier);
        ConfigurationSection configurationSection = configurationSectionSupplier.get();
        for (String key : configurationSection.getKeys(true)) {
            Object value = configurationSection.get(key);
            if (value instanceof ConfigurationSection) continue;
            this.section.addDefault(key, value);
        }
    }

    public String getInventoryName() {
        return this.getSection().getString("name");
    }

    public int getRows() {
        return this.getSection().getInt("rows");
    }

    @NotNull
    public ConfigurationSection getSection() {
        return this.section;
    }

    @NotNull
    public Set<Pair<Set<Integer>, ItemStack>> getDecorations() {
        LinkedHashSet<Pair<Set<Integer>, ItemStack>> set = new LinkedHashSet<Pair<Set<Integer>, ItemStack>>();
        ConfigurationSection decorationSection = this.getSection().getConfigurationSection("decorations");
        if (decorationSection == null) {
            return set;
        }
        Set keys = decorationSection.getKeys(false);
        keys.forEach(key -> {
            Object object = decorationSection.get(key + ".slot");
            ItemStack itemStack = decorationSection.getItemStack(key + ".item-stack").clone();
            LinkedHashSet<Integer> integers = new LinkedHashSet<Integer>();
            if (object instanceof Number) {
                integers.add(((Number)object).intValue());
            } else {
                List list = (List)object;
                list.forEach(integer -> integers.add(NumberConversions.toInt((Object)integer)));
            }
            set.add(new Pair(integers, itemStack));
        });
        return set;
    }

    @Override
    public void reload() {
        this.section = this.configurationSectionSupplier.get();
        this.others.forEach(configurationSectionSupplier -> {
            ConfigurationSection configurationSection = (ConfigurationSection)configurationSectionSupplier.get();
            for (String key : configurationSection.getKeys(true)) {
                Object value = configurationSection.get(key);
                if (value instanceof ConfigurationSection) continue;
                this.section.addDefault(key, value);
            }
        });
    }
}

