/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.utils.gui;

import de.derfrzocker.custom.ore.generator.utils.gui.BasicSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.InventoryGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BasicGui
extends InventoryGui {
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Map<Integer, Consumer<InventoryClickEvent>> button = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    @NotNull
    private final BasicSettings basicSettings;

    public BasicGui(@NotNull Plugin plugin, @NotNull BasicSettings basicSettings) {
        super(plugin);
        Validate.notNull((Object)basicSettings, (String)"BasicSettings can not be null");
        this.basicSettings = basicSettings;
        this.inventory = Bukkit.createInventory(null, (int)(basicSettings.getRows() * 9), (String)MessageUtil.replacePlaceHolder(plugin, basicSettings.getInventoryName(), new MessageValue[0]));
    }

    public BasicGui(@NotNull Plugin plugin, @NotNull BasicSettings basicSettings, MessageValue ... messageValue) {
        super(plugin);
        Validate.notNull((Object)basicSettings, (String)"BasicSettings can not be null");
        this.basicSettings = basicSettings;
        this.inventory = Bukkit.createInventory(null, (int)(basicSettings.getRows() * 9), (String)MessageUtil.replacePlaceHolder(plugin, basicSettings.getInventoryName(), messageValue));
    }

    public void addItem(int slot, @NotNull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"ItemStack can not be null");
        this.getInventory().setItem(slot, itemStack);
    }

    public void addItem(int slot, @NotNull ItemStack itemStack, @NotNull Consumer<InventoryClickEvent> consumer) {
        Validate.notNull((Object)itemStack, (String)"ItemStack can not be null");
        Validate.notNull(consumer, (String)"Consumer can not be null");
        this.button.put(slot, consumer);
        this.getInventory().setItem(slot, itemStack);
    }

    public void addDecorations(MessageValue ... messageValues) {
        this.basicSettings.getDecorations().forEach(pair -> {
            ItemStack itemStack = MessageUtil.replaceItemStack(this.getPlugin(), (ItemStack)pair.getSecond(), messageValues);
            ((Set)pair.getFirst()).forEach(integer -> this.addItem((int)integer, itemStack));
        });
    }

    @Override
    @NotNull
    Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        Consumer<InventoryClickEvent> consumer = this.button.get(event.getRawSlot());
        if (consumer != null) {
            consumer.accept(event);
        }
    }
}

